/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.object.ObjectByteArraySizeTerminated;
import org.farng.mp3.object.ObjectNumberFixedLength;
import org.farng.mp3.object.ObjectStringNullTerminated;

public class FrameBodyAENC
extends AbstractID3v2FrameBody {
    public FrameBodyAENC() {
    }

    public FrameBodyAENC(FrameBodyAENC body) {
        super(body);
    }

    public FrameBodyAENC(String owner, short previewStart, short previewLength, byte[] data) {
        this.setObject("Owner", owner);
        this.setObject("Preview Start", new Short(previewStart));
        this.setObject("Preview Length", new Short(previewLength));
        this.setObject("Encryption Info", data);
    }

    public FrameBodyAENC(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public String getIdentifier() {
        return "AENC\u0000" + this.getOwner();
    }

    public String getOwner() {
        return (String)this.getObject("Owner");
    }

    public void getOwner(String description) {
        this.setObject("Owner", description);
    }

    protected void setupObjectList() {
        this.objectList.add(new ObjectStringNullTerminated("Owner"));
        this.objectList.add(new ObjectNumberFixedLength("Preview Start", 2));
        this.objectList.add(new ObjectNumberFixedLength("Preview Length", 2));
        this.objectList.add(new ObjectByteArraySizeTerminated("Encryption Info"));
    }
}

