/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.object.ObjectByteArraySizeTerminated;
import org.farng.mp3.object.ObjectNumberHashMap;
import org.farng.mp3.object.ObjectStringNullTerminated;

public class FrameBodyAPIC
extends AbstractID3v2FrameBody {
    public FrameBodyAPIC() {
    }

    public FrameBodyAPIC(FrameBodyAPIC body) {
        super(body);
    }

    public FrameBodyAPIC(byte textEncoding, String mimeType, byte pictureType, String description, byte[] data) {
        this.setObject("Text Encoding", new Byte(textEncoding));
        this.setObject("MIME Type", mimeType);
        this.setObject("Picture Type", new Byte(pictureType));
        this.setObject("Description", description);
        this.setObject("Picture Data", data);
    }

    public FrameBodyAPIC(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public void setDescription(String description) {
        this.setObject("Description", description);
    }

    public String getDescription() {
        return (String)this.getObject("Description");
    }

    public String getIdentifier() {
        return "APIC\u0000" + this.getDescription();
    }

    protected void setupObjectList() {
        this.objectList.add(new ObjectNumberHashMap("Text Encoding", 1));
        this.objectList.add(new ObjectStringNullTerminated("MIME Type"));
        this.objectList.add(new ObjectNumberHashMap("Picture Type", 1));
        this.objectList.add(new ObjectStringNullTerminated("Description"));
        this.objectList.add(new ObjectByteArraySizeTerminated("Picture Data"));
    }
}

