/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.id3.AbstractID3v2FrameBody;

public class FrameBodyUnsupported
extends AbstractID3v2FrameBody {
    private String identifier = "";
    private byte[] value;

    public FrameBodyUnsupported(byte[] value) {
        this.value = value;
    }

    public FrameBodyUnsupported(FrameBodyUnsupported copyObject) {
        super(copyObject);
        this.identifier = new String(copyObject.identifier);
        this.value = (byte[])copyObject.value.clone();
    }

    public FrameBodyUnsupported(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getSize() {
        int size = 0;
        if (this.value != null) {
            size += this.value.length;
        }
        return size;
    }

    public boolean isSubsetOf(Object obj) {
        if (!(obj instanceof FrameBodyUnsupported)) {
            return false;
        }
        FrameBodyUnsupported object = (FrameBodyUnsupported)obj;
        String superset = new String(object.value);
        String subset = new String(this.value);
        if (superset.indexOf(subset) < 0) {
            return false;
        }
        return super.isSubsetOf(obj);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FrameBodyUnsupported)) {
            return false;
        }
        FrameBodyUnsupported object = (FrameBodyUnsupported)obj;
        if (!this.identifier.equals(object.identifier)) {
            return false;
        }
        if (!Arrays.equals(this.value, object.value)) {
            return false;
        }
        return super.equals(obj);
    }

    public void read(RandomAccessFile file) throws IOException, InvalidTagException {
        if (this.use6ByteHeader()) {
            file.seek(file.getFilePointer() - 3L);
            byte[] buffer = new byte[3];
            file.read(buffer);
            this.identifier = new String(buffer, 0, 3);
        } else {
            file.seek(file.getFilePointer() - 4L);
            byte[] buffer = new byte[4];
            file.read(buffer);
            this.identifier = new String(buffer);
        }
        int size = this.readHeader(file);
        this.value = new byte[size];
        file.read(this.value);
    }

    public String toString() {
        return "??" + this.getIdentifier() + " : " + new String(this.value);
    }

    public void write(RandomAccessFile file) throws IOException {
        this.writeHeader(file, this.getSize());
        file.write(this.value);
    }
}

