/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.lyrics3.AbstractLyrics3v2FieldBody;
import org.farng.mp3.object.ObjectLyrics3Image;

public class FieldBodyIMG
extends AbstractLyrics3v2FieldBody {
    private ArrayList images = new ArrayList();

    public FieldBodyIMG() {
    }

    public FieldBodyIMG(FieldBodyIMG copyObject) {
        super(copyObject);
        int i = 0;
        while (i < copyObject.images.size()) {
            ObjectLyrics3Image oldObject = (ObjectLyrics3Image)copyObject.images.get(i);
            this.images.add(new ObjectLyrics3Image(oldObject));
            ++i;
        }
    }

    public FieldBodyIMG(String imageString) {
        this.readString(imageString);
    }

    public FieldBodyIMG(ObjectLyrics3Image image) {
        this.images.add(image);
    }

    public FieldBodyIMG(RandomAccessFile file) throws InvalidTagException, IOException {
        this.read(file);
    }

    public String getIdentifier() {
        return "IMG";
    }

    public int getSize() {
        int size = 0;
        int i = 0;
        while (i < this.images.size()) {
            ObjectLyrics3Image image = (ObjectLyrics3Image)this.images.get(i);
            size += image.getSize() + 2;
            ++i;
        }
        return size - 2;
    }

    public boolean isSubsetOf(Object obj) {
        if (!(obj instanceof FieldBodyIMG)) {
            return false;
        }
        ArrayList superset = ((FieldBodyIMG)obj).images;
        int i = 0;
        while (i < this.images.size()) {
            if (!superset.contains(this.images.get(i))) {
                return false;
            }
            ++i;
        }
        return super.isSubsetOf(obj);
    }

    public void setValue(String value) {
        this.readString(value);
    }

    public String getValue() {
        return this.writeString();
    }

    public void addImage(ObjectLyrics3Image image) {
        this.images.add(image);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldBodyIMG)) {
            return false;
        }
        FieldBodyIMG object = (FieldBodyIMG)obj;
        if (!this.images.equals(object.images)) {
            return false;
        }
        return super.equals(obj);
    }

    public Iterator iterator() {
        return this.images.iterator();
    }

    public void read(RandomAccessFile file) throws InvalidTagException, IOException {
        byte[] buffer = new byte[5];
        file.read(buffer, 0, 5);
        int size = Integer.parseInt(new String(buffer, 0, 5));
        if (size == 0 && !TagOptionSingleton.getInstance().isLyrics3KeepEmptyFieldIfRead()) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }
        buffer = new byte[size];
        file.read(buffer);
        String imageString = new String(buffer);
        this.readString(imageString);
    }

    public String toString() {
        String str = this.getIdentifier() + " : ";
        int i = 0;
        while (i < this.images.size()) {
            str = str + this.images.get(i).toString() + " ; ";
            ++i;
        }
        return str;
    }

    public void write(RandomAccessFile file) throws IOException {
        int size = 0;
        int offset = 0;
        byte[] buffer = new byte[5];
        size = this.getSize();
        String str = Integer.toString(size);
        int i = 0;
        while (i < 5 - str.length()) {
            buffer[i] = 48;
            ++i;
        }
        offset += 5 - str.length();
        int i2 = 0;
        while (i2 < str.length()) {
            buffer[i2 + offset] = (byte)str.charAt(i2);
            ++i2;
        }
        offset += str.length();
        file.write(buffer, 0, 5);
        if (size > 0) {
            str = this.writeString();
            buffer = new byte[str.length()];
            int i3 = 0;
            while (i3 < str.length()) {
                buffer[i3] = (byte)str.charAt(i3);
                ++i3;
            }
            file.write(buffer);
        }
    }

    private void readString(String imageString) {
        ObjectLyrics3Image image;
        String token = "";
        int offset = 0;
        int delim = imageString.indexOf(TagConstant.CRLF);
        this.images = new ArrayList();
        while (delim >= 0) {
            token = imageString.substring(offset, delim);
            image = new ObjectLyrics3Image("Image");
            image.setFilename(token);
            this.images.add(image);
            offset = delim + TagConstant.CRLF.length();
            delim = imageString.indexOf(TagConstant.CRLF, offset);
        }
        if (offset < imageString.length()) {
            token = imageString.substring(offset);
            image = new ObjectLyrics3Image("Image");
            image.setFilename(token);
            this.images.add(image);
        }
    }

    private String writeString() {
        String str = "";
        int i = 0;
        while (i < this.images.size()) {
            ObjectLyrics3Image image = (ObjectLyrics3Image)this.images.get(i);
            str = str + image.writeString() + TagConstant.CRLF;
            ++i;
        }
        if (str.length() > 2) {
            return str.substring(0, str.length() - 2);
        }
        return str;
    }
}

