/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.lyrics3.AbstractLyrics3v2FieldBody;
import org.farng.mp3.object.ObjectID3v2LyricLine;
import org.farng.mp3.object.ObjectLyrics3Line;
import org.farng.mp3.object.ObjectLyrics3TimeStamp;

public class FieldBodyLYR
extends AbstractLyrics3v2FieldBody {
    private ArrayList lines = new ArrayList();

    public FieldBodyLYR() {
    }

    public FieldBodyLYR(FieldBodyLYR copyObject) {
        super(copyObject);
        int i = 0;
        while (i < copyObject.lines.size()) {
            ObjectLyrics3Line oldObject = (ObjectLyrics3Line)copyObject.lines.get(i);
            this.lines.add(new ObjectLyrics3Line(oldObject));
            ++i;
        }
    }

    public FieldBodyLYR(String line) {
        this.readString(line);
    }

    public FieldBodyLYR(FrameBodySYLT sync) {
        this.addLyric(sync);
    }

    public FieldBodyLYR(FrameBodyUSLT unsync) {
        this.addLyric(unsync);
    }

    public FieldBodyLYR(RandomAccessFile file) throws InvalidTagException, IOException {
        this.read(file);
    }

    public String getIdentifier() {
        return "LYR";
    }

    public void setLyric(String str) {
        this.readString(str);
    }

    public String getLyric() {
        return this.writeString();
    }

    public int getSize() {
        int size = 0;
        int i = 0;
        while (i < this.lines.size()) {
            ObjectLyrics3Line line = (ObjectLyrics3Line)this.lines.get(i);
            size += line.getSize() + 2;
            ++i;
        }
        return size;
    }

    public boolean isSubsetOf(Object obj) {
        if (!(obj instanceof FieldBodyLYR)) {
            return false;
        }
        ArrayList superset = ((FieldBodyLYR)obj).lines;
        int i = 0;
        while (i < this.lines.size()) {
            if (!superset.contains(this.lines.get(i))) {
                return false;
            }
            ++i;
        }
        return super.isSubsetOf(obj);
    }

    public void addLyric(FrameBodySYLT sync) {
        Iterator iterator = sync.iterator();
        HashMap<String, ObjectLyrics3Line> lineMap = new HashMap<String, ObjectLyrics3Line>();
        while (iterator.hasNext()) {
            ObjectLyrics3Line newLine;
            ObjectID3v2LyricLine currentLine = (ObjectID3v2LyricLine)iterator.next();
            currentLine = new ObjectID3v2LyricLine(currentLine);
            ObjectLyrics3TimeStamp timeStamp = new ObjectLyrics3TimeStamp("Time Stamp");
            timeStamp.setTimeStamp(currentLine.getTimeStamp(), sync.getTimeStampFormat());
            if (lineMap.containsKey(currentLine.getText())) {
                newLine = (ObjectLyrics3Line)lineMap.get(currentLine.getText());
                newLine.addTimeStamp(timeStamp);
                continue;
            }
            newLine = new ObjectLyrics3Line("Lyric Line");
            newLine.setLyric(currentLine);
            newLine.setTimeStamp(timeStamp);
            lineMap.put(currentLine.getText(), newLine);
            this.lines.add(newLine);
        }
    }

    public void addLyric(FrameBodyUSLT unsync) {
        ObjectLyrics3Line line = new ObjectLyrics3Line("Lyric Line");
        line.setLyric(new String(unsync.getLyric()));
        this.lines.add(line);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldBodyLYR)) {
            return false;
        }
        FieldBodyLYR object = (FieldBodyLYR)obj;
        if (!this.lines.equals(object.lines)) {
            return false;
        }
        return super.equals(obj);
    }

    public boolean hasTimeStamp() {
        boolean present = false;
        int i = 0;
        while (i < this.lines.size()) {
            if (((ObjectLyrics3Line)this.lines.get(i)).hasTimeStamp()) {
                present = true;
            }
            ++i;
        }
        return present;
    }

    public Iterator iterator() {
        return this.lines.iterator();
    }

    public void read(RandomAccessFile file) throws InvalidTagException, IOException {
        byte[] buffer = new byte[5];
        file.read(buffer, 0, 5);
        int size = Integer.parseInt(new String(buffer, 0, 5));
        if (size == 0 && !TagOptionSingleton.getInstance().isLyrics3KeepEmptyFieldIfRead()) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }
        buffer = new byte[size];
        file.read(buffer);
        String lineString = new String(buffer);
        this.readString(lineString);
    }

    public String toString() {
        String str = this.getIdentifier() + " : ";
        int i = 0;
        while (i < this.lines.size()) {
            str = str + this.lines.get(i).toString();
            ++i;
        }
        return str;
    }

    public void write(RandomAccessFile file) throws IOException {
        int size = 0;
        int offset = 0;
        byte[] buffer = new byte[5];
        String str = "";
        size = this.getSize();
        str = Integer.toString(size);
        int i = 0;
        while (i < 5 - str.length()) {
            buffer[i] = 48;
            ++i;
        }
        offset += 5 - str.length();
        int i2 = 0;
        while (i2 < str.length()) {
            buffer[i2 + offset] = (byte)str.charAt(i2);
            ++i2;
        }
        offset += str.length();
        file.write(buffer, 0, 5);
        if (size > 0) {
            str = this.writeString();
            buffer = new byte[str.length()];
            int i3 = 0;
            while (i3 < str.length()) {
                buffer[i3] = (byte)str.charAt(i3);
                ++i3;
            }
            file.write(buffer);
        }
    }

    private void readString(String lineString) {
        ObjectLyrics3Line line;
        String token = "";
        int offset = 0;
        int delim = lineString.indexOf(TagConstant.CRLF);
        this.lines = new ArrayList();
        while (delim >= 0) {
            token = lineString.substring(offset, delim);
            line = new ObjectLyrics3Line("Lyric Line");
            line.setLyric(token);
            this.lines.add(line);
            offset = delim + TagConstant.CRLF.length();
            delim = lineString.indexOf(TagConstant.CRLF, offset);
        }
        if (offset < lineString.length()) {
            token = lineString.substring(offset);
            line = new ObjectLyrics3Line("Lyric Line");
            line.setLyric(token);
            this.lines.add(line);
        }
    }

    private String writeString() {
        String str = "";
        int i = 0;
        while (i < this.lines.size()) {
            ObjectLyrics3Line line = (ObjectLyrics3Line)this.lines.get(i);
            str = str + line.writeString() + TagConstant.CRLF;
            ++i;
        }
        return str;
    }
}

