/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.id3.ID3v2_4;
import org.farng.mp3.lyrics3.AbstractLyrics3;
import org.farng.mp3.lyrics3.AbstractLyrics3v2FieldBody;
import org.farng.mp3.lyrics3.FieldBodyIND;
import org.farng.mp3.lyrics3.FieldBodyLYR;
import org.farng.mp3.lyrics3.Lyrics3v1;
import org.farng.mp3.lyrics3.Lyrics3v2Field;

public class Lyrics3v2
extends AbstractLyrics3 {
    private HashMap fieldMap = new HashMap();

    public Lyrics3v2() {
    }

    public Lyrics3v2(Lyrics3v2 copyObject) {
        super(copyObject);
        Iterator iterator = copyObject.fieldMap.keySet().iterator();
        while (iterator.hasNext()) {
            String oldIdentifier = iterator.next().toString();
            String newIdentifier = new String(oldIdentifier);
            Lyrics3v2Field newObject = new Lyrics3v2Field((Lyrics3v2Field)copyObject.fieldMap.get(newIdentifier));
            this.fieldMap.put(newIdentifier, newObject);
        }
    }

    public Lyrics3v2(AbstractMP3Tag mp3tag) {
        if (mp3tag != null) {
            if (mp3tag instanceof Lyrics3v2) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            if (mp3tag instanceof Lyrics3v1) {
                Lyrics3v1 lyricOld = (Lyrics3v1)mp3tag;
                Lyrics3v2Field newField = new Lyrics3v2Field(new FieldBodyLYR(lyricOld.getLyric()));
                this.fieldMap.put(newField.getIdentifier(), newField);
            } else {
                Iterator iterator = new ID3v2_4(mp3tag).iterator();
                while (iterator.hasNext()) {
                    try {
                        Lyrics3v2Field newField = new Lyrics3v2Field((AbstractID3v2Frame)iterator.next());
                        if (newField == null) continue;
                        this.fieldMap.put(newField.getIdentifier(), newField);
                    }
                    catch (TagException ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public Lyrics3v2(RandomAccessFile file) throws TagNotFoundException, IOException {
        this.read(file);
    }

    public void setField(Lyrics3v2Field field) {
        this.fieldMap.put(field.getIdentifier(), field);
    }

    public Lyrics3v2Field getField(String identifier) {
        return (Lyrics3v2Field)this.fieldMap.get(identifier);
    }

    public int getFieldCount() {
        return this.fieldMap.size();
    }

    public String getIdentifier() {
        return "Lyrics3v2.00";
    }

    public int getSize() {
        int size = 0;
        Iterator iterator = this.fieldMap.values().iterator();
        while (iterator.hasNext()) {
            Lyrics3v2Field field = (Lyrics3v2Field)iterator.next();
            size += field.getSize();
        }
        return 11 + size;
    }

    public void append(AbstractMP3Tag tag) {
        Lyrics3v2 oldTag = this;
        Lyrics3v2 newTag = null;
        if (tag != null) {
            newTag = tag instanceof Lyrics3v2 ? (Lyrics3v2)tag : new Lyrics3v2(tag);
            Iterator<Object> iterator = newTag.fieldMap.values().iterator();
            while (iterator.hasNext()) {
                Lyrics3v2Field field = (Lyrics3v2Field)iterator.next();
                if (!oldTag.hasField(field.getIdentifier())) {
                    oldTag.setField(field);
                    continue;
                }
                AbstractLyrics3v2FieldBody body = (AbstractLyrics3v2FieldBody)oldTag.getField(field.getIdentifier()).getBody();
                boolean save = TagOptionSingleton.getInstance().getLyrics3SaveField(field.getIdentifier());
                if (body.getSize() != 0 || !save) continue;
                oldTag.setField(field);
            }
            iterator = oldTag.fieldMap.keySet().iterator();
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                TagOptionSingleton.getInstance().setLyrics3SaveField(id, true);
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Lyrics3v2)) {
            return false;
        }
        Lyrics3v2 object = (Lyrics3v2)obj;
        if (!this.fieldMap.equals(object.fieldMap)) {
            return false;
        }
        return super.equals(obj);
    }

    public boolean hasField(String identifier) {
        return this.fieldMap.containsKey(identifier);
    }

    public Iterator iterator() {
        return this.fieldMap.values().iterator();
    }

    public void overwrite(AbstractMP3Tag tag) {
        Lyrics3v2 oldTag = this;
        Lyrics3v2 newTag = null;
        if (tag != null) {
            newTag = tag instanceof Lyrics3v2 ? (Lyrics3v2)tag : new Lyrics3v2(tag);
            Iterator<Object> iterator = newTag.fieldMap.values().iterator();
            while (iterator.hasNext()) {
                Lyrics3v2Field field = (Lyrics3v2Field)iterator.next();
                if (!TagOptionSingleton.getInstance().getLyrics3SaveField(field.getIdentifier())) continue;
                oldTag.setField(field);
            }
            iterator = oldTag.fieldMap.keySet().iterator();
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                TagOptionSingleton.getInstance().setLyrics3SaveField(id, true);
            }
        }
    }

    public void read(RandomAccessFile file) throws TagNotFoundException, IOException {
        if (!this.seek(file)) {
            throw new TagNotFoundException("Lyrics3v2.00 Tag Not Found");
        }
        int lyricSize = this.seekSize(file);
        this.seek(file);
        long filePointer = file.getFilePointer();
        this.fieldMap = new HashMap();
        while (file.getFilePointer() - filePointer < (long)(lyricSize - 11)) {
            try {
                Lyrics3v2Field lyric = new Lyrics3v2Field(file);
                this.setField(lyric);
            }
            catch (InvalidTagException ex) {
                // empty catch block
            }
        }
    }

    public void removeField(String identifier) {
        this.fieldMap.remove(identifier);
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[11];
        String lyricEnd = "";
        String lyricStart = "";
        long filePointer = 0L;
        long lyricSize = 0L;
        file.seek(file.length() - 128L - 9L);
        file.read(buffer, 0, 9);
        lyricEnd = new String(buffer, 0, 9);
        if (lyricEnd.equals("LYRICS200")) {
            filePointer = file.getFilePointer();
        } else {
            file.seek(file.length() - 9L);
            file.read(buffer, 0, 9);
            lyricEnd = new String(buffer, 0, 9);
            if (lyricEnd.equals("LYRICS200")) {
                filePointer = file.getFilePointer();
            } else {
                return false;
            }
        }
        file.seek(filePointer -= 15L);
        file.read(buffer, 0, 6);
        lyricSize = Integer.parseInt(new String(buffer, 0, 6));
        file.seek(filePointer - lyricSize);
        file.read(buffer, 0, 11);
        lyricStart = new String(buffer, 0, 11);
        return lyricStart.equals("LYRICSBEGIN");
    }

    public String toString() {
        Iterator iterator = this.fieldMap.values().iterator();
        String str = this.getIdentifier() + " " + this.getSize() + "\n";
        while (iterator.hasNext()) {
            Lyrics3v2Field field = (Lyrics3v2Field)iterator.next();
            str = str + field.toString() + "\n";
        }
        return str;
    }

    public void updateField(String identifier) {
        if (identifier.equals("IND")) {
            Lyrics3v2Field lyrField;
            boolean lyricsPresent = this.fieldMap.containsKey("LYR");
            boolean timeStampPresent = false;
            if (lyricsPresent) {
                lyrField = (Lyrics3v2Field)this.fieldMap.get("LYR");
                FieldBodyLYR lyrBody = (FieldBodyLYR)lyrField.getBody();
                timeStampPresent = lyrBody.hasTimeStamp();
            }
            lyrField = new Lyrics3v2Field(new FieldBodyIND(lyricsPresent, timeStampPresent));
            this.setField(lyrField);
        }
    }

    public void write(AbstractMP3Tag tag) {
        Lyrics3v2 oldTag = this;
        Lyrics3v2 newTag = null;
        if (tag != null) {
            newTag = tag instanceof Lyrics3v2 ? (Lyrics3v2)tag : new Lyrics3v2(tag);
            Iterator iterator = newTag.fieldMap.values().iterator();
            oldTag.fieldMap.clear();
            while (iterator.hasNext()) {
                Lyrics3v2Field field = (Lyrics3v2Field)iterator.next();
                oldTag.setField(field);
            }
        }
    }

    public void write(RandomAccessFile file) throws IOException {
        int offset = 0;
        byte[] buffer = new byte[15];
        ID3v1 id3v1tag = new ID3v1();
        id3v1tag = id3v1tag.getID3tag(file);
        this.delete(file);
        file.seek(file.length());
        long filePointer = file.getFilePointer();
        String str = "LYRICSBEGIN";
        int i = 0;
        while (i < str.length()) {
            buffer[i] = (byte)str.charAt(i);
            ++i;
        }
        file.write(buffer, 0, str.length());
        this.updateField("IND");
        Lyrics3v2Field field = (Lyrics3v2Field)this.fieldMap.get("IND");
        field.write(file);
        Iterator iterator = this.fieldMap.values().iterator();
        while (iterator.hasNext()) {
            field = (Lyrics3v2Field)iterator.next();
            String id = field.getIdentifier();
            boolean save = TagOptionSingleton.getInstance().getLyrics3SaveField(id);
            if (id.equals("IND") || !save) continue;
            field.write(file);
        }
        long size = file.getFilePointer() - filePointer;
        if ((long)this.getSize() != size) {
            // empty if block
        }
        str = Long.toString(size);
        int i2 = 0;
        while (i2 < 6 - str.length()) {
            buffer[i2] = 48;
            ++i2;
        }
        offset += 6 - str.length();
        int i3 = 0;
        while (i3 < str.length()) {
            buffer[i3 + offset] = (byte)str.charAt(i3);
            ++i3;
        }
        offset += str.length();
        str = "LYRICS200";
        int i4 = 0;
        while (i4 < str.length()) {
            buffer[i4 + offset] = (byte)str.charAt(i4);
            ++i4;
        }
        file.write(buffer, 0, offset += str.length());
        if (id3v1tag != null) {
            id3v1tag.write(file);
        }
    }

    private int seekSize(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[11];
        String lyricEnd = "";
        long filePointer = 0L;
        file.seek(file.length() - 128L - 9L);
        file.read(buffer, 0, 9);
        lyricEnd = new String(buffer, 0, 9);
        if (lyricEnd.equals("LYRICS200")) {
            filePointer = file.getFilePointer();
        } else {
            file.seek(file.length() - 9L);
            file.read(buffer, 0, 9);
            lyricEnd = new String(buffer, 0, 9);
            if (lyricEnd.equals("LYRICS200")) {
                filePointer = file.getFilePointer();
            } else {
                return -1;
            }
        }
        file.seek(filePointer -= 15L);
        file.read(buffer, 0, 6);
        return Integer.parseInt(new String(buffer, 0, 6));
    }
}

