/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.object.AbstractMP3Object;

public class ObjectBooleanByte
extends AbstractMP3Object {
    int bitPosition = -1;

    public ObjectBooleanByte(String identifier, int bitPosition) {
        if (bitPosition < 0 || bitPosition > 7) {
            throw new IndexOutOfBoundsException("Bit position needs to be from 0 - 7 : " + bitPosition);
        }
        this.bitPosition = bitPosition;
        this.identifier = identifier;
    }

    public ObjectBooleanByte(ObjectBooleanByte copyObject) {
        super(copyObject);
        this.bitPosition = copyObject.bitPosition;
    }

    public int getBitPosition() {
        return this.bitPosition;
    }

    public int getSize() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectBooleanByte)) {
            return false;
        }
        ObjectBooleanByte object = (ObjectBooleanByte)obj;
        if (this.bitPosition != object.bitPosition) {
            return false;
        }
        return super.equals(obj);
    }

    public void readByteArray(byte[] arr, int offset) {
        if (arr == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0 || offset >= arr.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + arr.length);
        }
        byte newValue = arr[offset];
        newValue = (byte)(newValue >> this.bitPosition);
        this.value = new Boolean((newValue = (byte)(newValue & 1)) == 1);
    }

    public String toString() {
        return "" + this.value;
    }

    public byte[] writeByteArray() {
        byte[] retValue = new byte[1];
        if (this.value != null) {
            retValue[0] = (byte)((Boolean)this.value != false ? 1 : 0);
            retValue[0] = (byte)(retValue[0] << this.bitPosition);
        }
        return retValue;
    }
}

