/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import java.util.Iterator;
import java.util.LinkedList;
import org.farng.mp3.object.AbstractMP3Object;
import org.farng.mp3.object.ObjectID3v2LyricLine;
import org.farng.mp3.object.ObjectLyrics3TimeStamp;

public class ObjectLyrics3Line
extends AbstractMP3Object {
    private LinkedList timeStamp = new LinkedList();
    private String lyric = "";

    public ObjectLyrics3Line(String identifier) {
        this.identifier = identifier;
    }

    public ObjectLyrics3Line(ObjectLyrics3Line copyObject) {
        super(copyObject);
        this.lyric = new String(copyObject.lyric);
        int i = 0;
        while (i < copyObject.timeStamp.size()) {
            ObjectLyrics3TimeStamp newTimeStamp = new ObjectLyrics3TimeStamp((ObjectLyrics3TimeStamp)copyObject.timeStamp.get(i));
            this.timeStamp.add(newTimeStamp);
            ++i;
        }
    }

    public void setLyric(String lyric) {
        this.lyric = lyric;
    }

    public void setLyric(ObjectID3v2LyricLine line) {
        this.lyric = line.getText();
    }

    public String getLyric() {
        return this.lyric;
    }

    public int getSize() {
        int size = 0;
        int i = 0;
        while (i < this.timeStamp.size()) {
            size += ((ObjectLyrics3TimeStamp)this.timeStamp.get(i)).getSize();
            ++i;
        }
        return size + this.lyric.length();
    }

    public void setTimeStamp(ObjectLyrics3TimeStamp time) {
        this.timeStamp.clear();
        this.timeStamp.add(time);
    }

    public Iterator getTimeStamp() {
        return this.timeStamp.iterator();
    }

    public void addLyric(String newLyric) {
        this.lyric = this.lyric + newLyric;
    }

    public void addLyric(ObjectID3v2LyricLine line) {
        this.lyric = this.lyric + line.getText();
    }

    public void addTimeStamp(ObjectLyrics3TimeStamp time) {
        this.timeStamp.add(time);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectLyrics3Line)) {
            return false;
        }
        ObjectLyrics3Line object = (ObjectLyrics3Line)obj;
        if (!this.lyric.equals(object.lyric)) {
            return false;
        }
        if (!this.timeStamp.equals(object.timeStamp)) {
            return false;
        }
        return super.equals(obj);
    }

    public boolean hasTimeStamp() {
        return !this.timeStamp.isEmpty();
    }

    public void readString(String lineString, int offset) {
        if (lineString == null) {
            throw new NullPointerException("Image is null");
        }
        if (offset < 0 || offset >= lineString.length()) {
            throw new IndexOutOfBoundsException("Offset to line is out of bounds: offset = " + offset + ", line.length()" + lineString.length());
        }
        int delim = 0;
        this.timeStamp = new LinkedList();
        delim = lineString.indexOf("[", offset);
        while (delim >= 0) {
            offset = lineString.indexOf("]", delim) + 1;
            ObjectLyrics3TimeStamp time = new ObjectLyrics3TimeStamp("Time Stamp");
            time.readString(lineString.substring(delim, offset));
            this.timeStamp.add(time);
            delim = lineString.indexOf("[", offset);
        }
        this.lyric = lineString.substring(offset);
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.timeStamp.size()) {
            str = str + this.timeStamp.get(i).toString();
            ++i;
        }
        return "timeStamp = " + str + ", lyric = " + this.lyric + "\n";
    }

    public String writeString() {
        String str = "";
        int i = 0;
        while (i < this.timeStamp.size()) {
            ObjectLyrics3TimeStamp time = (ObjectLyrics3TimeStamp)this.timeStamp.get(i);
            str = str + time.writeString();
            ++i;
        }
        return str + this.lyric;
    }
}

