/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.TagUtility;
import org.farng.mp3.object.AbstractMP3Object;

public class ObjectNumberFixedLength
extends AbstractMP3Object {
    int length = 0;

    public ObjectNumberFixedLength(String identifier, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Length is less than zero: " + this.length);
        }
        this.length = size;
        this.identifier = identifier;
    }

    public ObjectNumberFixedLength(ObjectNumberFixedLength copyObject) {
        super(copyObject);
        this.length = copyObject.length;
    }

    public int getLength() {
        return this.length;
    }

    public void setSize(int length) {
        if (length > 0) {
            this.length = length;
        }
    }

    public int getSize() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectNumberFixedLength)) {
            return false;
        }
        ObjectNumberFixedLength object = (ObjectNumberFixedLength)obj;
        if (this.length != object.length) {
            return false;
        }
        return super.equals(obj);
    }

    public void readByteArray(byte[] arr, int offset) {
        if (arr == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0 || offset >= arr.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + arr.length);
        }
        long lvalue = 0L;
        int i = offset;
        while (i < offset + this.length) {
            lvalue <<= 8;
            lvalue += (long)arr[i];
            ++i;
        }
        this.value = new Long(lvalue);
    }

    public void readString(String str, int offset) {
        if (str == null) {
            throw new NullPointerException("Number string is null");
        }
        if (offset < 0 || offset >= str.length()) {
            throw new IndexOutOfBoundsException("Offset to number string is out of bounds: offset = " + offset + ", string.length()" + str.length());
        }
        this.value = Long.getLong(str.substring(offset));
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public byte[] writeByteArray() {
        byte[] arr = new byte[this.length];
        if (this.value != null) {
            long temp = TagUtility.getWholeNumber(this.value);
            int i = this.length - 1;
            while (i >= 0) {
                arr[i] = (byte)(temp & 0xFFL);
                temp >>= 8;
                --i;
            }
        }
        return arr;
    }

    public String writeString() {
        if (this.value == null) {
            return String.valueOf(new char[this.length]);
        }
        return this.value.toString();
    }
}

