/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.TagUtility;
import org.farng.mp3.object.AbstractMP3Object;

public class ObjectNumberVariableLength
extends AbstractMP3Object {
    int minLength = 1;

    public ObjectNumberVariableLength(String identifier, int minimumSize) {
        this.identifier = identifier;
        if (minimumSize > 0) {
            this.minLength = minimumSize;
        }
    }

    public ObjectNumberVariableLength(ObjectNumberVariableLength copyObject) {
        super(copyObject);
        this.minLength = copyObject.minLength;
    }

    public int getMaximumLenth() {
        return 8;
    }

    public int getMinimumLength() {
        return this.minLength;
    }

    public void setMinimumSize(int minimumSize) {
        if (minimumSize > 0) {
            this.minLength = minimumSize;
        }
    }

    public int getSize() {
        if (this.value == null) {
            return 0;
        }
        long temp = TagUtility.getWholeNumber(this.value);
        int size = 0;
        int i = 1;
        while (i <= 8) {
            int current = (byte)temp & 0xFF;
            if (current != 0) {
                size = i;
            }
            temp >>= 8;
            ++i;
        }
        return this.minLength > size ? this.minLength : size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectNumberVariableLength)) {
            return false;
        }
        ObjectNumberVariableLength object = (ObjectNumberVariableLength)obj;
        if (this.minLength != object.minLength) {
            return false;
        }
        return super.equals(obj);
    }

    public void readByteArray(byte[] arr, int offset) {
        if (arr == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0 || offset >= arr.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + arr.length);
        }
        long lvalue = 0L;
        int i = offset;
        while (i < arr.length) {
            lvalue <<= 8;
            lvalue += (long)arr[i];
            ++i;
        }
        this.value = new Long(lvalue);
    }

    public void readString(String str, int offset) {
        if (str == null) {
            throw new NullPointerException("Number string is null");
        }
        if (offset < 0 || offset >= str.length()) {
            throw new IndexOutOfBoundsException("Offset to number string is out of bounds: offset = " + offset + ", string.length()" + str.length());
        }
        this.value = Long.getLong(str.substring(offset));
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public byte[] writeByteArray() {
        byte[] arr;
        int size = this.getSize();
        if (size == 0) {
            arr = new byte[]{};
        } else {
            long temp = TagUtility.getWholeNumber(this.value);
            arr = new byte[size];
            int i = size - 1;
            while (i >= 0) {
                arr[i] = (byte)(temp & 0xFFL);
                temp >>= 8;
                --i;
            }
        }
        return arr;
    }

    public String writeString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }
}

