/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.TagUtility;
import org.farng.mp3.object.AbstractMP3Object;

public class ObjectStringFixedLength
extends AbstractMP3Object {
    int length = 0;

    public ObjectStringFixedLength(String identifier, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length is less than zero: " + length);
        }
        this.identifier = identifier;
        this.length = length;
    }

    public ObjectStringFixedLength(ObjectStringFixedLength copyObject) {
        super(copyObject);
        this.length = copyObject.length;
    }

    public void setLength(int size) {
        this.length = size;
    }

    public int getLength() {
        return this.length;
    }

    public int getSize() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectStringFixedLength)) {
            return false;
        }
        ObjectStringFixedLength object = (ObjectStringFixedLength)obj;
        if (this.length != object.length) {
            return false;
        }
        return super.equals(obj);
    }

    public void readString(String str, int offset) {
        if (str == null) {
            throw new NullPointerException("String is null");
        }
        if (offset < 0 || offset >= str.length()) {
            throw new IndexOutOfBoundsException("Offset to String is out of bounds: offset = " + offset + ", string.length()" + str.length());
        }
        this.value = str.substring(offset, this.length + offset);
    }

    public String toString() {
        return this.writeString();
    }

    public String writeString() {
        int vlength;
        String str = "";
        str = this.value == null ? String.valueOf(new char[this.length]) : ((vlength = ((String)this.value).length()) > this.length ? ((String)this.value).substring(0, this.length) : (vlength == this.length ? (String)this.value : TagUtility.padString((String)this.value, this.length, ' ', false)));
        return str;
    }
}

