/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.object.AbstractMP3Object;

public class ObjectStringNullTerminated
extends AbstractMP3Object {
    public ObjectStringNullTerminated(String identifier) {
        this.identifier = identifier;
    }

    public ObjectStringNullTerminated(ObjectStringNullTerminated object) {
        super(object);
    }

    public int getSize() {
        int len = 0;
        if (this.value != null) {
            len = ((String)this.value).length() + 1;
        }
        return len;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectStringNullTerminated)) {
            return false;
        }
        return super.equals(obj);
    }

    public void readString(String str, int offset) {
        if (str == null) {
            throw new NullPointerException("String is null");
        }
        if (offset < 0 || offset >= str.length()) {
            throw new IndexOutOfBoundsException("Offset to String is out of bounds: offset = " + offset + ", string.length()" + str.length());
        }
        int delim = str.indexOf(0, offset);
        this.value = delim >= 0 ? str.substring(offset, delim) : str.substring(offset);
    }

    public String toString() {
        return (String)this.value;
    }

    public String writeString() {
        String string = "";
        if (this.value != null) {
            string = (String)this.value + '\u0000';
        }
        return string;
    }
}

