/*
 * Decompiled with CFR 0.152.
 */
package palm.todo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import palmdb.AppInfo;
import palmdb.Category;
import palmdb.PalmDbException;

public class ToDoAppInfo
extends AppInfo {
    protected List categories = new LinkedList();

    public ToDoAppInfo() {
        int i = 0;
        while (i < 16) {
            Category cat = new Category();
            if (i == 0) {
                cat.setName("Unfiled");
            }
            if (i == 1) {
                cat.setName("Personal");
            }
            if (i == 2) {
                cat.setName("Business");
            }
            cat.setId((byte)i);
            this.categories.add(cat);
            ++i;
        }
    }

    public ToDoAppInfo(byte[] data) throws PalmDbException {
        super(data);
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
            byte[] namebuffer = new byte[16];
            byte[] categoryids = new byte[16];
            dis.readShort();
            Category[] cats = new Category[16];
            int i = 0;
            while (i < 16) {
                cats[i] = new Category();
                dis.read(namebuffer);
                cats[i].setName(new String(namebuffer).trim());
                ++i;
            }
            dis.read(categoryids);
            i = 0;
            while (i < 16) {
                cats[i].setId(categoryids[i]);
                this.categories.add(cats[i]);
                ++i;
            }
            dis.readByte();
            dis.readByte();
        }
        catch (IOException ioe) {
            throw new PalmDbException(ioe);
        }
    }

    public byte[] getData() throws PalmDbException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            byte[] namebuffer = new byte[16];
            byte[] categoryids = new byte[16];
            dos.writeShort(0);
            int i = 0;
            while (i < this.categories.size()) {
                byte[] name;
                Category cat = (Category)this.categories.get(i);
                String sname = cat.getName();
                if (sname == null) {
                    sname = "";
                }
                System.arraycopy(name, 0, namebuffer, 0, (name = sname.getBytes()).length > 16 ? 16 : name.length);
                dos.write(namebuffer);
                namebuffer = new byte[16];
                categoryids[i] = cat.getId();
                ++i;
            }
            dos.write(categoryids);
            dos.writeByte(0);
            dos.writeByte(0);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new PalmDbException(ioe);
        }
    }

    public Category getCategoryById(byte id) {
        Iterator iter = this.getCategories().iterator();
        while (iter.hasNext()) {
            Category cat = (Category)iter.next();
            if (cat.getId() != id) continue;
            return cat;
        }
        return null;
    }

    public Collection getCategories() {
        return new LinkedList(this.categories);
    }
}

