/*
 * Decompiled with CFR 0.152.
 */
package palm.todo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import palm.todo.ToDoAppInfo;
import palm.todo.ToDoDatabase;
import palmdb.Category;
import palmdb.Database;
import palmdb.PalmDbException;
import palmdb.Record;
import palmdb.RecordHeader;
import palmdb.StringUtil;

public class ToDoRecord
extends Record {
    private String description;
    private Date dueDate;
    private boolean isCompleted;
    private int priority;
    private boolean isPrivate;
    private String note;
    private static final int YEAR_SHIFT_FACTOR = 9;
    private static final int MONTH_SHIFT_FACTOR = 5;
    private static final int HOUR_SHIFT_FACTOR = 8;
    private static final int FIRST_YEAR = 1904;
    private static final int COMPLETED_BIT = 128;
    private static final int PRIORITY_BITS = 127;

    ToDoRecord(ToDoDatabase db) {
        super(db);
        this.description = "";
        this.dueDate = new Date();
        this.isCompleted = false;
        this.priority = 1;
        this.isPrivate = false;
        this.note = "";
    }

    ToDoRecord(RecordHeader header, byte[] data) throws PalmDbException {
        super(header, data);
        try {
            int c;
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
            short dt = dis.readShort();
            Calendar cal = Calendar.getInstance();
            int year = ((dt & 0xFE00) >>> 9) + 1904;
            int month = ((dt & 0x1E0) >>> 5) - 1;
            int day = dt & 0x1F;
            cal.set(year, month, day);
            this.dueDate = cal.getTime();
            byte flags = dis.readByte();
            this.isCompleted = (flags & 0x80) != 0;
            this.priority = flags & 0x7F;
            StringBuffer sb = new StringBuffer();
            do {
                if ((c = dis.read()) == 0) continue;
                sb.append((char)c);
            } while (c > 0);
            this.description = sb.toString();
            sb = new StringBuffer();
            do {
                if ((c = dis.read()) == 0) continue;
                sb.append((char)c);
            } while (c > 0);
            this.note = sb.toString();
        }
        catch (IOException ioe) {
            throw new PalmDbException(ioe);
        }
    }

    public Category getCategory() {
        ToDoAppInfo tai = (ToDoAppInfo)this.getDatabase().getAppInfo();
        return tai.getCategoryById((byte)this.getRecordHeader().getCategory());
    }

    public void setCategory(Category newCat) {
        this.getRecordHeader().setCategory(newCat.getId());
    }

    public void setCategory(String category) {
        ToDoAppInfo tai = (ToDoAppInfo)this.getDatabase().getAppInfo();
        Iterator iter = tai.getCategories().iterator();
        while (iter.hasNext()) {
            Category cat = (Category)iter.next();
            if (!cat.getName().equals(category)) continue;
            this.setCategory(cat);
            break;
        }
    }

    private void rebuildRecord() throws PalmDbException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            int flags = 0;
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.dueDate);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            int year = cal.get(1) - 1904;
            int d = year << 9 | month << 5 | day;
            dos.writeShort(d);
            if (this.isCompleted) {
                flags = (byte)(flags | 0x80);
            }
            flags = (byte)(flags | this.priority & 0x7F);
            dos.writeByte(flags);
            byte[] bytes = StringUtil.getNullTerminatedBytes(this.description);
            dos.write(bytes);
            bytes = StringUtil.getNullTerminatedBytes(this.note);
            dos.write(bytes);
            this.setRecordData(baos.toByteArray());
        }
        catch (IOException ioe) {
            throw new PalmDbException(ioe);
        }
    }

    ToDoRecord(Database db) {
        super(db);
    }

    public String getDescription() {
        return this.description;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public String getNote() {
        return this.note;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setDescription(String description) throws Exception {
        this.description = description;
        this.rebuildRecord();
    }

    public void setDueDate(Date dueDate) throws Exception {
        this.dueDate = dueDate;
        this.rebuildRecord();
    }

    public void setIsCompleted(boolean isCompleted) throws Exception {
        this.isCompleted = isCompleted;
        this.rebuildRecord();
    }

    public void setIsPrivate(boolean isPrivate) throws Exception {
        this.isPrivate = isPrivate;
        this.rebuildRecord();
    }

    public void setNote(String note) throws Exception {
        this.note = note;
        this.rebuildRecord();
    }

    public void setPriority(int priority) throws Exception {
        if (priority < 0 || priority > 5) {
            throw new Exception("only values 1-5 are valid");
        }
        this.priority = priority;
        this.rebuildRecord();
    }
}

