/*
 * Decompiled with CFR 0.152.
 */
package palmdb;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import palmdb.AppInfo;
import palmdb.BitOps;
import palmdb.PalmDate;
import palmdb.PalmDbException;
import palmdb.Record;
import palmdb.RecordHeader;
import palmdb.StringUtil;

public class Database {
    protected String title;
    protected short attributes = 0;
    protected short version;
    protected int creationDate = (int)new PalmDate().getSecSince1904();
    protected int modificationDate = (int)new PalmDate().getSecSince1904();
    protected int lastBackupDate;
    protected int modificationNumber;
    protected int appInfoId;
    protected int sortInfoId;
    protected String type;
    protected String creator;
    protected int uniqueIdSeed = (int)System.currentTimeMillis();
    protected int nextRecordListId;
    protected List warnings = new LinkedList();
    protected AppInfo appInfo;
    protected List records = new LinkedList();

    public void addWarning(String warning) {
        this.warnings.add(warning);
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public Iterator getWarnings() {
        return this.warnings.iterator();
    }

    protected Database() {
        this.title = "Unknown";
        this.type = "DATA";
        this.creator = "UNKN";
    }

    public PalmDate getCreationDate() {
        return new PalmDate(this.creationDate * 1000);
    }

    public PalmDate getLastModificationDate() {
        return new PalmDate(this.modificationDate * 1000);
    }

    public PalmDate getLastBackupDate() {
        return new PalmDate(this.lastBackupDate * 1000);
    }

    public String getType() {
        return this.type;
    }

    public String getCreator() {
        return this.creator;
    }

    public Database(String title, String type, String creator) {
        this.title = title;
        this.type = type;
        this.creator = creator;
    }

    public Database(InputStream is) throws PalmDbException {
        try {
            byte[] data;
            DataInputStream dis = new DataInputStream(is);
            byte[] btitle = new byte[32];
            dis.read(btitle);
            this.title = StringUtil.getString(btitle);
            this.attributes = dis.readShort();
            this.version = dis.readShort();
            this.creationDate = dis.readInt();
            this.modificationDate = dis.readInt();
            this.lastBackupDate = dis.readInt();
            this.modificationNumber = dis.readInt();
            this.appInfoId = dis.readInt();
            this.sortInfoId = dis.readInt();
            int tmp = dis.readInt();
            this.type = BitOps.integerToString(tmp);
            tmp = dis.readInt();
            this.creator = BitOps.integerToString(tmp);
            this.uniqueIdSeed = dis.readInt();
            this.nextRecordListId = dis.readInt();
            int numberOfRecords = dis.readShort();
            RecordHeader[] headers = new RecordHeader[numberOfRecords];
            int i = 0;
            while (i < numberOfRecords) {
                headers[i] = new RecordHeader(dis);
                ++i;
            }
            dis.readShort();
            int start = 0;
            int end = 0;
            if (this.appInfoId != 0) {
                start = this.appInfoId;
                int chunklength = 0;
                chunklength = headers.length > 0 ? headers[0].localChunkId - start : dis.available();
                data = new byte[chunklength];
                dis.read(data);
                this.appInfo = this.buildAppInfo(data);
            }
            int i2 = 0;
            while (i2 < numberOfRecords) {
                if (!headers[i2].isDelete()) {
                    start = headers[i2].localChunkId;
                    int n = end = i2 == numberOfRecords - 1 ? -1 : headers[i2 + 1].localChunkId;
                    if (end == -1) {
                        data = new byte[4096];
                        int read = dis.read(data);
                        if (read == -1) {
                            throw new PalmDbException("Whoa, invalid db");
                        }
                        byte[] trimmed = new byte[read];
                        System.arraycopy(data, 0, trimmed, 0, read);
                        Record rec = this.buildRecord(headers[i2], trimmed);
                        rec.setDatabase(this);
                        this.records.add(rec);
                    } else {
                        data = new byte[end - start];
                        dis.read(data);
                        Record rec = this.buildRecord(headers[i2], data);
                        rec.setDatabase(this);
                        this.records.add(rec);
                    }
                }
                ++i2;
            }
        }
        catch (IOException ioe) {
            throw new PalmDbException(ioe);
        }
    }

    public void write(OutputStream os) throws PalmDbException {
        try {
            Record rec;
            DataOutputStream dos = new DataOutputStream(os);
            byte[] btitle = new byte[32];
            int i = 0;
            while (i < btitle.length) {
                btitle[i++] = 0;
            }
            System.arraycopy(this.title.getBytes(), 0, btitle, 0, this.title.length());
            dos.write(btitle);
            dos.writeShort(this.attributes);
            dos.writeShort(this.version);
            dos.writeInt(this.creationDate);
            dos.writeInt(this.modificationDate);
            dos.writeInt(this.lastBackupDate);
            dos.writeInt(this.modificationNumber);
            this.appInfoId = 8 * this.records.size() + 80;
            dos.writeInt(this.appInfoId);
            dos.writeInt(this.sortInfoId);
            dos.write(this.type.getBytes(), 0, 4);
            dos.write(this.creator.getBytes(), 0, 4);
            dos.writeInt(this.uniqueIdSeed);
            dos.writeInt(this.nextRecordListId);
            dos.writeShort(this.records.size());
            int localChunkId = this.appInfoId + this.appInfo.getDataLength();
            int i2 = 0;
            while (i2 < this.records.size()) {
                rec = (Record)this.records.get(i2);
                rec.getRecordHeader().localChunkId = localChunkId;
                rec.getRecordHeader().write(dos);
                localChunkId += rec.getRecordSize();
                ++i2;
            }
            dos.writeShort(0);
            dos.write(this.appInfo.getData());
            i2 = 0;
            while (i2 < this.records.size()) {
                rec = (Record)this.records.get(i2);
                dos.write(rec.getRecordData());
                ++i2;
            }
        }
        catch (IOException ioe) {
            throw new PalmDbException(ioe);
        }
    }

    public AppInfo getAppInfo() {
        return this.appInfo;
    }

    protected Record buildRecord(RecordHeader header, byte[] data) throws PalmDbException {
        return new Record(header, data);
    }

    protected AppInfo buildAppInfo(byte[] data) throws PalmDbException {
        return new AppInfo(data);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle.length() > 32 ? newTitle.substring(0, 32) : newTitle;
    }

    public Iterator getRecordsIterator() {
        return this.records.iterator();
    }

    public int getRecordCount() {
        return this.records.size();
    }

    public Record getRecord(int idx) {
        return (Record)this.records.get(idx);
    }

    public void deleteRecord(Record r) {
        this.records.remove(r);
        this.appInfo.invalidate();
    }

    public Record findByUniqueId(int id) {
        Iterator iter = this.getRecordsIterator();
        while (iter.hasNext()) {
            Record r = (Record)iter.next();
            if (!r.isId(id)) continue;
            return r;
        }
        return null;
    }

    public int indexOf(Record record) {
        return this.records.indexOf(record);
    }

    public short getVersion() {
        return this.version;
    }

    public short getAttributes() {
        return this.attributes;
    }

    public void setAttributes(short s) {
        this.attributes = s;
    }

    public void setCreator(String string) {
        this.creator = string;
    }
}

