/*
 * Decompiled with CFR 0.152.
 */
package palmdb;

import palmdb.Database;
import palmdb.RecordHeader;
import palmdb.util.ByteArray;

public class Record {
    protected ByteArray recordData;
    protected RecordHeader recordHeader;
    protected Database database;

    protected Record(RecordHeader header, byte[] data) {
        this.recordHeader = header;
        this.recordData = new ByteArray(data);
        System.out.println(this.recordData);
    }

    private final int findNextId() {
        int nextId = 0;
        int i = 0;
        while (i < this.database.records.size()) {
            Record r = (Record)this.database.records.get(i);
            nextId = Math.max(r.recordHeader.uniqueId, nextId);
            ++i;
        }
        return nextId + 1;
    }

    protected Record(Database db) {
        this.database = db;
        this.recordHeader = new RecordHeader();
        this.recordHeader.uniqueId = this.findNextId();
    }

    public boolean isId(int id) {
        return this.recordHeader.isId(id);
    }

    public int getRecordSize() {
        return this.getRecordData().length;
    }

    public byte[] getRecordData() {
        return this.recordData.getBytes();
    }

    public RecordHeader getRecordHeader() {
        return this.recordHeader;
    }

    public void setRecordData(byte[] recordData) {
        if (this.recordData == null) {
            this.recordData = new ByteArray(recordData);
        } else {
            this.recordData.setBytes(recordData);
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }
}

