/*
 * Decompiled with CFR 0.152.
 */
package palmdb;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class VersionInfo {
    private static VersionInfo instance = null;
    private static VersionInfo latestAvailable = null;
    int major;
    int minor;
    int build;
    String buildDate;
    static /* synthetic */ Class class$0;

    public int getBuild() {
        return this.build;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.build;
    }

    private static void load(VersionInfo vi, Properties p) {
        vi.major = Integer.parseInt(p.getProperty("version.major"));
        vi.minor = Integer.parseInt(p.getProperty("version.minor"));
        vi.build = Integer.parseInt(p.getProperty("build.number"));
        vi.buildDate = p.getProperty("build.date");
    }

    public boolean newerThan(VersionInfo vi) {
        if (this.major > vi.major) {
            return true;
        }
        if (this.major == vi.major && this.minor > vi.minor) {
            return true;
        }
        return this.major == vi.major && this.minor == vi.minor && this.build > vi.build;
    }

    public static final VersionInfo instance() {
        if (instance == null) {
            instance = new VersionInfo();
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("palmdb.VersionInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InputStream is = clazz.getResourceAsStream("/version.properties");
                Properties p = new Properties();
                p.load(is);
                VersionInfo.load(instance, p);
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public static final VersionInfo latestAvailable() {
        if (latestAvailable == null) {
            latestAvailable = new VersionInfo();
            try {
                URL url = new URL("http://www.chickenshick.com/jpilot-db/download/version.properties");
                InputStream is = url.openStream();
                Properties p = new Properties();
                p.load(is);
                VersionInfo.load(latestAvailable, p);
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return latestAvailable;
    }
}

