/*
 * Decompiled with CFR 0.152.
 */
package pilotdb;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import palmdb.AppInfo;
import palmdb.BitOps;
import palmdb.Database;
import palmdb.PalmDbException;
import palmdb.Record;
import palmdb.RecordHeader;
import pilotdb.PilotDBAppInfo;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBException;
import pilotdb.PilotDBField;
import pilotdb.PilotDBLFindOptions;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.PilotDBTime;
import pilotdb.PilotDBView;
import pilotdb.PilotDBViewOptions;
import pilotdb.calc.EvaluationContext;
import pilotdb.calc.Script;

public class PilotDBDatabase
extends Database {
    public static final String DEFAULT_CREATOR = "DBOS";
    public static final String DEFAULT_TYPE = "DB00";
    protected boolean dirty = false;

    public static final boolean isProbablyPilotDB(InputStream is) {
        try {
            is.skip(60L);
            DataInputStream dis = new DataInputStream(is);
            int tmp = dis.readInt();
            String type = BitOps.integerToString(tmp);
            boolean isPilotDB = false;
            if (type.equals(DEFAULT_TYPE)) {
                isPilotDB = true;
            }
            dis = null;
            is.close();
            return isPilotDB;
        }
        catch (Exception e) {
            System.err.print(e);
            return false;
        }
    }

    protected PilotDBDatabase(AppInfo appInfo) {
        this.appInfo = appInfo;
    }

    public void deleteRecord(Record r) {
        super.deleteRecord(r);
        this.markAsDirty();
    }

    public void markAsDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void markAsClean() {
        this.dirty = false;
    }

    public PilotDBDatabase(InputStream is) throws IOException, PalmDbException {
        super(is);
    }

    public PilotDBDatabase(String title, String type, String creator, PilotDBSchema schema) {
        super(title, type, creator);
        if (title == null) {
            title = "null";
        }
        if (type == null) {
            type = DEFAULT_TYPE;
        }
        if (creator == null) {
            creator = DEFAULT_CREATOR;
        }
        this.appInfo = new PilotDBAppInfo(schema);
    }

    public PilotDBRecord createRecord() throws IOException, PalmDbException {
        PilotDBRecord r = new PilotDBRecord(this);
        this.records.add(r);
        this.markAsDirty();
        return r;
    }

    public PilotDBSchema getSchema() {
        return ((PilotDBAppInfo)this.appInfo).schema;
    }

    protected AppInfo buildAppInfo(byte[] data) throws PalmDbException {
        return new PilotDBAppInfo(this, data);
    }

    public PilotDBRecord findRecord(int fieldIdx, String value) throws PilotDBException {
        int i = 0;
        while (i < this.records.size()) {
            PilotDBRecord r = (PilotDBRecord)this.records.get(i);
            if (r.getObject(fieldIdx).toString().equals(value)) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public void recalculate() throws PilotDBException {
        EvaluationContext ctx = new EvaluationContext();
        ctx.setDatabase(this);
        ctx.setSchema(this.getSchema());
        int i = 0;
        while (i < this.getSchema().getFieldCount()) {
            PilotDBField field = this.getSchema().getField(i);
            if (field.getType() == 9) {
                Script script = field.getScript();
                if (script.getSortExpression() != null) {
                    script.getSortExpression().evaluateVoid(ctx);
                    ctx.setSorted(true);
                }
                int r = 0;
                while (r < this.getRecordCount()) {
                    PilotDBRecord rec = (PilotDBRecord)this.getRecord(r);
                    rec.updateCalculated(i, ctx);
                    ++r;
                }
            }
            ++i;
        }
    }

    protected Record buildRecord(RecordHeader header, byte[] data) throws PilotDBException {
        PilotDBRecord rec = new PilotDBRecord(this, header, data);
        return rec;
    }

    private PilotDBAppInfo getPilotDBAppInfo() {
        return (PilotDBAppInfo)this.appInfo;
    }

    public PilotDBView createView(String name) {
        PilotDBView view = new PilotDBView(name, this);
        ((PilotDBAppInfo)this.appInfo).addView(view);
        return view;
    }

    public PilotDBViewOptions getViewOptions() {
        return this.getPilotDBAppInfo().getViewOptions();
    }

    public PilotDBLFindOptions getLFindOptions() {
        return this.getPilotDBAppInfo().getLFindOptions();
    }

    public void removeView(int idx) {
        this.getPilotDBAppInfo().removeView(this.getView(idx));
        this.markAsDirty();
    }

    public void removeView(String name) {
        this.getPilotDBAppInfo().removeView(this.getView(name));
        this.markAsDirty();
    }

    public void removeView(PilotDBView view) {
        this.getPilotDBAppInfo().removeView(view);
        this.markAsDirty();
    }

    public List getViews() {
        return this.getPilotDBAppInfo().getViews();
    }

    public PilotDBView getView(int idx) {
        return this.getPilotDBAppInfo().getView(idx);
    }

    public int getViewCount() {
        return this.getPilotDBAppInfo().getViewCount();
    }

    public PilotDBView getView(String name) {
        return this.getPilotDBAppInfo().getView(name);
    }

    public void write(OutputStream os) throws PalmDbException {
        this.markAsClean();
        super.write(os);
    }

    public List sortSnapshot(int fieldIndex, boolean desc) {
        LinkedList toSort = new LinkedList(this.records);
        ByFieldComparator comparator = new ByFieldComparator(fieldIndex, desc);
        Collections.sort(toSort, comparator);
        return toSort;
    }

    public void sort(int fieldIndex, boolean desc) {
        ByFieldComparator comparator = new ByFieldComparator(fieldIndex, desc);
        Collections.sort(this.records, comparator);
    }

    public void setViews(List list) {
        this.getPilotDBAppInfo().setViews(list);
    }

    public void addWarning(String string) {
        this.warnings.add(string);
    }

    class ByFieldComparator
    implements Comparator {
        int fieldIdx = 0;
        boolean desc = false;

        ByFieldComparator(int fieldIndex, boolean desc) {
            this.fieldIdx = fieldIndex;
            this.desc = desc;
        }

        public int compare(Object arg0, Object arg1) {
            PilotDBRecord lhs = (PilotDBRecord)arg0;
            PilotDBRecord rhs = (PilotDBRecord)arg1;
            try {
                int fieldType = PilotDBDatabase.this.getSchema().getField(this.fieldIdx).getType();
                int compare = 0;
                switch (fieldType) {
                    case 10: {
                        String s1 = null;
                        String s2 = null;
                        s1 = lhs.getLinked(this.fieldIdx);
                        s2 = rhs.getLinked(this.fieldIdx);
                        compare = s1.compareTo(s2);
                        break;
                    }
                    case 5: {
                        String s1 = lhs.getNote(this.fieldIdx);
                        String s2 = rhs.getNote(this.fieldIdx);
                        compare = s1.compareTo(s2);
                        break;
                    }
                    case 6: {
                        String s1 = lhs.getListChoice(this.fieldIdx);
                        String s2 = rhs.getListChoice(this.fieldIdx);
                        compare = s1.compareTo(s2);
                        break;
                    }
                    case 7: {
                        String s1 = lhs.getLinkText(this.fieldIdx);
                        String s2 = rhs.getLinkText(this.fieldIdx);
                        compare = s1.compareTo(s2);
                        break;
                    }
                    case 0: {
                        String s1 = lhs.getString(this.fieldIdx);
                        String s2 = rhs.getString(this.fieldIdx);
                        compare = s1.compareTo(s2);
                        break;
                    }
                    case 1: {
                        Boolean b1 = new Boolean(lhs.getBoolean(this.fieldIdx));
                        Boolean b2 = new Boolean(rhs.getBoolean(this.fieldIdx));
                        compare = b1.toString().compareTo(b2.toString());
                        break;
                    }
                    case 2: {
                        Integer i1 = new Integer(lhs.getInteger(this.fieldIdx));
                        Integer i2 = new Integer(rhs.getInteger(this.fieldIdx));
                        compare = i1.compareTo(i2);
                        break;
                    }
                    case 3: {
                        PilotDBDate d1 = lhs.getDate(this.fieldIdx);
                        PilotDBDate d2 = rhs.getDate(this.fieldIdx);
                        compare = d1.compareTo(d2);
                        break;
                    }
                    case 4: {
                        PilotDBTime t1 = lhs.getTime(this.fieldIdx);
                        PilotDBTime t2 = rhs.getTime(this.fieldIdx);
                        compare = t1.compareTo(t2);
                        break;
                    }
                    case 8: {
                        Double db1 = new Double(lhs.getFloat(this.fieldIdx));
                        Double db2 = new Double(rhs.getFloat(this.fieldIdx));
                        compare = db1.compareTo(db2);
                        break;
                    }
                    default: {
                        return 0;
                    }
                }
                return this.desc ? compare * -1 : compare;
            }
            catch (PilotDBException pde) {
                throw new RuntimeException(pde);
            }
        }
    }
}

