/*
 * Decompiled with CFR 0.152.
 */
package pilotdb;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBSchema;
import pilotdb.PilotDBTime;
import pilotdb.calc.EvaluationContext;
import pilotdb.calc.InvalidCodeException;
import pilotdb.calc.LispCodeExpressionParser;
import pilotdb.calc.Script;

public class PilotDBField
implements Cloneable {
    public static final String[] FIELD_TYPE_NAMES = new String[]{"string", "boolean", "integer", "date", "time", "note", "list", "link", "float", "calculated", "linked"};
    public static final int TYPE_STRING = 0;
    public static final int TYPE_BOOL = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_DATE = 3;
    public static final int TYPE_TIME = 4;
    public static final int TYPE_NOTE = 5;
    public static final int TYPE_LIST = 6;
    public static final int TYPE_LINK = 7;
    public static final int TYPE_FLOAT = 8;
    public static final int TYPE_CALCULATED = 9;
    public static final int TYPE_LINKED = 10;
    PilotDBSchema schema = null;
    int type = -1;
    String name = null;
    int integerDefaultValue = 0;
    short integerIncrement = 0;
    double doubleDefaultValue = 0.0;
    String stringDefaultValue;
    PilotDBDate dateDefault;
    boolean dateUseCurrent;
    PilotDBTime timeDefault;
    boolean timeUseCurrent;
    String linkDbName = null;
    int linkFieldNum = -1;
    int linkedLinkFieldIndex = -1;
    int linkedTableColumnIndex = -1;
    Script script;
    short scriptVersion = (short)32;
    short scriptAccessReq;
    short scriptReturnType;
    boolean valid = true;
    List listChoices = new LinkedList();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Field [");
        sb.append(" type =").append(FIELD_TYPE_NAMES[this.type]);
        sb.append(" name=").append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public short getScriptVersion() {
        return this.scriptVersion;
    }

    public short getScriptAccessRequirements() {
        return this.scriptAccessReq;
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(String code) throws InvalidCodeException {
        LispCodeExpressionParser parser = new LispCodeExpressionParser();
        EvaluationContext ctx = new EvaluationContext();
        this.script = parser.parse(ctx, code);
        System.out.println("Should set the return type right here.");
    }

    public PilotDBTime getDefaultTime() {
        return this.timeDefault;
    }

    public int getLinkedLinkFieldIndex() {
        return this.linkedLinkFieldIndex;
    }

    public int getLinkedTableColumnIndex() {
        return this.linkedTableColumnIndex;
    }

    public String getLinkTable() {
        return this.linkDbName;
    }

    public int getLinkColumnNumber() {
        return this.linkFieldNum;
    }

    public String getDefaultString() {
        return this.stringDefaultValue;
    }

    public int getDefaultInteger() {
        return this.integerDefaultValue;
    }

    public int getIncrement() {
        return this.integerIncrement;
    }

    public double getDefaultDouble() {
        return this.doubleDefaultValue;
    }

    public PilotDBDate getDefaultDate() {
        return this.dateDefault;
    }

    public String getName() {
        return this.name;
    }

    public String getListChoice(int idx) {
        if (idx == -1) {
            return "";
        }
        return this.listChoices.get(idx).toString();
    }

    public int getListChoiceCount() {
        return this.listChoices.size();
    }

    public void addListChoice(String choice) {
        this.listChoices.add(choice);
    }

    public int getListChoiceIndex(String c) {
        return this.listChoices.indexOf(c);
    }

    public int getType() {
        return this.type;
    }

    public PilotDBField() {
    }

    public PilotDBField(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public PilotDBDate getDateDefault() {
        return this.dateDefault;
    }

    public double getDoubleDefaultValue() {
        return this.doubleDefaultValue;
    }

    public int getIntegerDefaultValue() {
        return this.integerDefaultValue;
    }

    public short getIntegerIncrement() {
        return this.integerIncrement;
    }

    public String getLinkDbName() {
        return this.linkDbName;
    }

    public int getLinkFieldNum() {
        return this.linkFieldNum;
    }

    public List getListChoices() {
        return this.listChoices;
    }

    public String getStringDefaultValue() {
        return this.stringDefaultValue;
    }

    public PilotDBTime getTimeDefault() {
        return this.timeDefault;
    }

    public void setDateDefault(PilotDBDate dateDefault) {
        this.dateDefault = dateDefault;
        if (dateDefault != null) {
            this.dateUseCurrent = false;
        }
    }

    public void setDoubleDefaultValue(double doubleDefaultValue) {
        this.doubleDefaultValue = doubleDefaultValue;
    }

    public void setIntegerDefaultValue(int integerDefaultValue) {
        this.integerDefaultValue = integerDefaultValue;
    }

    public void setIntegerIncrement(short integerIncrement) {
        this.integerIncrement = integerIncrement;
    }

    public void setLinkDbName(String linkDbName) {
        this.linkDbName = linkDbName;
    }

    public void setLinkFieldNum(int linkFieldNum) {
        this.linkFieldNum = linkFieldNum;
    }

    public void setListChoices(List listChoices) {
        this.listChoices = listChoices;
    }

    public void setStringDefaultValue(String stringDefaultValue) {
        this.stringDefaultValue = stringDefaultValue;
    }

    public void setTimeDefault(PilotDBTime timeDefault) {
        this.timeDefault = timeDefault;
        if (timeDefault != null) {
            this.timeUseCurrent = false;
        }
    }

    public boolean isDateUseCurrent() {
        return this.dateUseCurrent;
    }

    public boolean isTimeUseCurrent() {
        return this.timeUseCurrent;
    }

    public void setDateUseCurrent(boolean dateUseCurrent) {
        this.dateUseCurrent = dateUseCurrent;
        if (dateUseCurrent) {
            this.dateDefault = null;
        }
    }

    public void setTimeUseCurrent(boolean timeUseCurrent) {
        this.timeUseCurrent = timeUseCurrent;
        if (timeUseCurrent) {
            this.timeDefault = null;
        }
    }

    public void setLinkedLinkFieldIndex(int linkedLinkFieldIndex) {
        this.linkedLinkFieldIndex = linkedLinkFieldIndex;
    }

    public void setLinkedTableColumnIndex(int linkedTableColumnIndex) {
        this.linkedTableColumnIndex = linkedTableColumnIndex;
    }

    public Object clone() {
        PilotDBField clone = new PilotDBField();
        clone.type = this.type;
        clone.name = this.name;
        clone.integerDefaultValue = this.integerDefaultValue;
        clone.integerIncrement = this.integerIncrement;
        clone.doubleDefaultValue = this.doubleDefaultValue;
        clone.stringDefaultValue = this.stringDefaultValue;
        if (this.dateDefault != null) {
            clone.dateDefault = (PilotDBDate)this.dateDefault.clone();
        }
        clone.dateUseCurrent = this.dateUseCurrent;
        if (this.timeDefault != null) {
            clone.timeDefault = (PilotDBTime)this.timeDefault.clone();
        }
        clone.timeUseCurrent = this.timeUseCurrent;
        clone.linkDbName = this.linkDbName;
        clone.linkFieldNum = this.linkFieldNum;
        clone.linkedLinkFieldIndex = this.linkedLinkFieldIndex;
        clone.linkedTableColumnIndex = this.linkedTableColumnIndex;
        clone.script = this.script;
        clone.scriptVersion = this.scriptVersion;
        clone.scriptAccessReq = this.scriptAccessReq;
        clone.scriptReturnType = this.scriptReturnType;
        if (this.listChoices != null) {
            clone.listChoices = new ArrayList(this.listChoices);
        }
        return clone;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(int i) {
        this.type = i;
    }

    public void setSchema(PilotDBSchema schema) {
        this.schema = schema;
    }

    public PilotDBSchema getSchema() {
        return this.schema;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

