/*
 * Decompiled with CFR 0.152.
 */
package pilotdb;

import palmdb.PalmDbException;
import palmdb.Record;
import palmdb.RecordHeader;
import palmdb.util.ByteArray;
import pilotdb.PilotDBConstants;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBEnvironment;
import pilotdb.PilotDBException;
import pilotdb.PilotDBField;
import pilotdb.PilotDBSchema;
import pilotdb.PilotDBTime;
import pilotdb.calc.EvaluationContext;

public class PilotDBRecord
extends Record
implements PilotDBConstants {
    public PilotDBDatabase getDb() {
        return (PilotDBDatabase)this.database;
    }

    private final void checkFieldType(int field, int type) throws PilotDBException {
        int actualType = this.getSchema().getField(field).getType();
        if (actualType != type) {
            throw new PilotDBException("Invalid Type, expected: " + PilotDBField.FIELD_TYPE_NAMES[field] + " but found " + PilotDBField.FIELD_TYPE_NAMES[actualType]);
        }
    }

    private final void dirty() {
        if (this.database != null) {
            this.getDb().markAsDirty();
        }
    }

    public PilotDBRecord(PilotDBDatabase db, RecordHeader hdr, byte[] data) throws PilotDBException {
        super(hdr, data);
        this.database = db;
    }

    private void setOffset(int fieldIdx, short offset) {
        this.recordData.position(fieldIdx * 2);
        this.recordData.SHORT(offset, false);
    }

    private int getOffset(int fieldIdx) {
        this.recordData.position(fieldIdx * 2);
        return this.recordData.SHORT();
    }

    private int getOffsetCount() {
        return this.getSchema().getFieldCount();
    }

    protected PilotDBRecord(PilotDBDatabase db) throws PilotDBException {
        super(db);
        this.dirty();
        int fc = db.getSchema().getFieldCount();
        this.recordData = new ByteArray();
        PilotDBField field = null;
        int beginOffset = fc * 2;
        int i = 0;
        while (i < fc) {
            field = db.getSchema().getField(i);
            this.recordData.SHORT(beginOffset, true);
            switch (field.type) {
                case 2: 
                case 3: {
                    beginOffset += 4;
                    break;
                }
                case 0: 
                case 1: 
                case 6: 
                case 10: {
                    ++beginOffset;
                    break;
                }
                case 7: {
                    beginOffset += 5;
                    break;
                }
                case 4: 
                case 9: {
                    beginOffset += 2;
                    break;
                }
                case 5: {
                    beginOffset += 3;
                    break;
                }
                case 8: {
                    beginOffset += 8;
                    break;
                }
                default: {
                    throw new RuntimeException("invalid field type");
                }
            }
            ++i;
        }
        i = 0;
        while (i < fc) {
            field = db.getSchema().getField(i);
            switch (field.type) {
                case 2: 
                case 3: {
                    this.recordData.INT(0, true);
                    break;
                }
                case 6: {
                    this.recordData.BYTE((byte)-1, true);
                }
                case 0: 
                case 1: 
                case 10: {
                    this.recordData.BYTE((byte)0, true);
                    break;
                }
                case 7: {
                    this.recordData.BYTE((byte)0, true).INT(0, true);
                    break;
                }
                case 4: {
                    this.recordData.BYTE((byte)24, true);
                    this.recordData.BYTE((byte)0, true);
                    break;
                }
                case 9: {
                    this.recordData.SHORT(0, true);
                    break;
                }
                case 5: {
                    this.recordData.BYTE((byte)0, true).SHORT(0, true);
                    break;
                }
                case 8: {
                    this.recordData.DOUBLE(0.0, true);
                    break;
                }
                default: {
                    throw new RuntimeException("invalid field type");
                }
            }
            ++i;
        }
        PilotDBSchema schema = db.getSchema();
        int fieldCount = schema.getFieldCount();
        field = null;
        int i2 = 0;
        while (i2 < fieldCount) {
            field = schema.getField(i2);
            switch (field.type) {
                case 2: {
                    this.setInteger(i2, field.integerDefaultValue);
                    break;
                }
                case 0: {
                    if (field.stringDefaultValue == null) break;
                    this.setString(i2, field.stringDefaultValue);
                    break;
                }
                case 3: {
                    if (field.dateUseCurrent) {
                        this.setDate(i2, new PilotDBDate());
                        break;
                    }
                    if (field.dateDefault == null) break;
                    this.setDate(i2, field.dateDefault);
                    break;
                }
                case 4: {
                    if (field.timeUseCurrent) {
                        PilotDBTime time = new PilotDBTime();
                        this.setTime(i2, time);
                        break;
                    }
                    if (field.timeDefault == null) break;
                    this.setTime(i2, field.timeDefault);
                    break;
                }
                case 8: {
                    this.setFloat(i2, field.doubleDefaultValue);
                }
            }
            ++i2;
        }
    }

    public String getCalculatedText(int idx) {
        String ret = null;
        this.recordData.position(this.getOffset(idx));
        byte type = this.recordData.BYTE();
        switch (type) {
            case 2: {
                ret = String.valueOf(this.recordData.INT());
                break;
            }
            case 8: {
                ret = String.valueOf(this.recordData.DOUBLE());
                break;
            }
            case 4: {
                PilotDBTime time = new PilotDBTime(this.recordData.BYTE(), this.recordData.BYTE());
                ret = time.toString();
                break;
            }
            case 3: {
                PilotDBDate dat = new PilotDBDate(this.recordData.SHORT(), this.recordData.BYTE(), this.recordData.BYTE());
                ret = dat.toString();
                break;
            }
            case 0: {
                ret = this.recordData.SZ();
            }
        }
        return ret;
    }

    public void setFloat(int fieldIdx, double newValue) throws PilotDBException {
        this.checkFieldType(fieldIdx, 8);
        this.dirty();
        this.recordData.position(this.getOffset(fieldIdx));
        this.recordData.DOUBLE(newValue, false);
    }

    public void setInteger(int fieldIdx, int newValue) throws PilotDBException {
        this.checkFieldType(fieldIdx, 2);
        this.dirty();
        this.recordData.position(this.getOffset(fieldIdx));
        this.recordData.INT(newValue, false);
    }

    public void setDate(int fieldIdx, PilotDBDate date) throws PilotDBException {
        this.checkFieldType(fieldIdx, 3);
        this.dirty();
        this.recordData.position(this.getOffset(fieldIdx));
        this.recordData.SHORT(date.year, false);
        this.recordData.BYTE((byte)date.month, false);
        this.recordData.BYTE((byte)date.date, false);
    }

    public void setTime(int fieldIdx, PilotDBTime time) throws PilotDBException {
        this.checkFieldType(fieldIdx, 4);
        this.dirty();
        this.recordData.position(this.getOffset(fieldIdx));
        this.recordData.BYTE((byte)time.hour, false);
        this.recordData.BYTE((byte)time.minute, false);
    }

    public void setBoolean(int idx, boolean value) throws PilotDBException {
        this.checkFieldType(idx, 1);
        this.dirty();
        this.recordData.position(this.getOffset(idx));
        this.recordData.BYTE(value ? (byte)1 : 0, false);
    }

    public int getList(int idx) throws PilotDBException {
        this.recordData.position(this.getOffset(idx));
        return this.recordData.BYTE();
    }

    public String getListChoice(int idx) throws PilotDBException {
        int i = this.getList(idx);
        return this.getSchema().getField(idx).getListChoice(i);
    }

    public void setList(int idx, int choice) throws PilotDBException {
        this.checkFieldType(idx, 6);
        this.dirty();
        this.recordData.position(this.getOffset(idx));
        this.recordData.BYTE((byte)choice, false);
    }

    public void setList(int idx, String choice) throws PilotDBException {
        try {
            int i = this.getSchema().getField(idx).getListChoiceIndex(choice);
            this.setList(idx, i);
        }
        catch (Exception e) {
            this.setList(idx, 255);
        }
    }

    public void setNoteTitle(int idx, String newValue) throws PilotDBException {
        this.checkFieldType(idx, 5);
        this.dirty();
        this.recordData.position(this.getOffset(idx));
        this.recordData.mark();
        String oldTitle = this.recordData.SZ();
        this.recordData.resetToMark();
        this.recordData.cut(oldTitle.length() + 1);
        this.recordData.insertBlank(newValue.length() + 1);
        this.recordData.SZ(newValue, false);
        this.recordData.mark();
        short noteOffset = this.recordData.SHORT();
        this.recordData.resetToMark();
        if (noteOffset != 0) {
            this.recordData.SHORT((short)(noteOffset + (newValue.length() - oldTitle.length())), false);
        }
        this.updateOffsets(idx, newValue.length() - oldTitle.length());
    }

    private void updateNoteOffsets(int beforeFieldIndex, int amount) throws PilotDBException {
        int i = 0;
        while (i < beforeFieldIndex) {
            PilotDBField field = this.getSchema().getField(i);
            if (field.type == 5) {
                this.updateNoteOffset(i, amount);
            }
            ++i;
        }
    }

    private void updateNoteOffset(int idx, int amount) throws PilotDBException {
        this.checkFieldType(idx, 5);
        this.dirty();
        this.recordData.position(this.getOffset(idx));
        this.recordData.SZ();
        this.recordData.mark();
        short noteOffset = this.recordData.SHORT();
        this.recordData.resetToMark();
        if (noteOffset == 0) {
            return;
        }
        this.recordData.SHORT((short)(noteOffset + amount), false);
    }

    public void setNote(int idx, String newValue) throws PilotDBException {
        this.checkFieldType(idx, 5);
        this.dirty();
        this.recordData.position(this.getOffset(idx));
        this.recordData.SZ();
        this.recordData.mark();
        short noteOffset = this.recordData.SHORT();
        if (noteOffset == 0) {
            this.recordData.resetToMark();
            this.recordData.SHORT(this.recordData.length(), false);
            this.recordData.position(this.recordData.length());
            this.recordData.mark();
            this.recordData.BYTE((byte)0, true);
            this.recordData.resetToMark();
        } else {
            this.recordData.position(noteOffset);
        }
        this.recordData.truncate();
        this.recordData.SZ(newValue, true);
    }

    public void setString(int idx, String newValue) throws PilotDBException {
        if (newValue == null) {
            newValue = "";
        }
        this.checkFieldType(idx, 0);
        this.dirty();
        this.recordData.position(this.getOffset(idx));
        this.recordData.mark();
        String oldValue = this.recordData.SZ();
        this.recordData.resetToMark();
        int oldLen = oldValue.length() + 1;
        int newLen = newValue.length() + 1;
        this.recordData.cut(oldValue.length() + 1);
        this.updateOffsets(idx, newLen - oldLen);
        this.recordData.position(this.getOffset(idx));
        this.recordData.insertBlank(newValue.length() + 1);
        this.recordData.SZ(newValue, false);
        this.updateNoteOffsets(idx, newLen - oldLen);
    }

    protected void updateLinked(int linkFieldIndex) throws PalmDbException {
        PilotDBSchema schema = this.getSchema();
        int i = 0;
        while (i < schema.getFieldCount()) {
            PilotDBField linkedField = schema.getField(i);
            if (linkedField.getType() == 10 && linkedField.linkedLinkFieldIndex == linkFieldIndex) {
                this.setLinked(i);
            }
            ++i;
        }
    }

    protected void setLinked(int idx) throws PalmDbException {
        this.checkFieldType(idx, 10);
        this.dirty();
        PilotDBField linkedField = this.getSchema().getField(idx);
        PilotDBRecord linkedRecord = this.getLinkedRecord(linkedField.getLinkedLinkFieldIndex());
        String newValue = String.valueOf(linkedRecord.getObject(linkedField.linkedTableColumnIndex));
        this.recordData.position(this.getOffset(idx));
        this.recordData.mark();
        String oldValue = this.recordData.SZ();
        this.recordData.resetToMark();
        int oldLen = oldValue.length() + 1;
        int newLen = newValue.length() + 1;
        this.updateOffsets(idx, newLen - oldLen);
        this.recordData.position(this.getOffset(idx));
        this.recordData.cut(oldLen);
        this.recordData.insertBlank(newValue.length() + 1);
        this.recordData.SZ(newValue, false);
        this.updateNoteOffsets(idx, newLen - oldLen);
    }

    protected PilotDBRecord getLinkedRecord(int idx) throws PalmDbException {
        PilotDBField linkField = this.getSchema().getField(idx);
        if (PilotDBEnvironment.getEnvironment(this.getDb()) == null) {
            throw new PilotDBException("Unable to find linked database:" + linkField.linkDbName);
        }
        PilotDBDatabase linkedDb = PilotDBEnvironment.getEnvironment(this.getDb()).openDatabase(linkField.linkDbName);
        PilotDBRecord linkedRec = linkedDb.findRecord(linkField.linkFieldNum, this.getLinkText(idx));
        if (linkedRec == null) {
            throw new PilotDBException("Unable to find linked record:" + this.getLinkText(idx));
        }
        return linkedRec;
    }

    public String getLinked(int idx) throws PilotDBException {
        this.checkFieldType(idx, 10);
        this.recordData.position(this.getOffset(idx));
        return this.recordData.SZ();
    }

    public String getLinkText(int idx) throws PilotDBException {
        this.checkFieldType(idx, 7);
        this.recordData.position(this.getOffset(idx));
        this.recordData.INT();
        return this.recordData.SZ();
    }

    public void setLink(int idx, String value) throws PalmDbException {
        this.checkFieldType(idx, 7);
        this.dirty();
        PilotDBField field = this.getSchema().getField(idx);
        int uniqueId = 0;
        if (PilotDBEnvironment.getEnvironment(this.getDb()) == null) {
            throw new PilotDBException("Unable to find linked database:" + field.linkDbName);
        }
        PilotDBDatabase linkedDb = PilotDBEnvironment.getEnvironment(this.getDb()).openDatabase(field.linkDbName);
        if (linkedDb == null) {
            throw new PilotDBException("Unable to find linked database:" + field.linkDbName);
        }
        PilotDBRecord linkedRec = linkedDb.findRecord(field.linkFieldNum, value);
        if (linkedRec == null) {
            throw new PilotDBException("Unable to find linked record:" + value);
        }
        uniqueId = linkedRec.getRecordHeader().uniqueId;
        this.recordData.position(this.getOffset(idx));
        this.recordData.INT(uniqueId, false);
        this.recordData.mark();
        String oldValue = this.recordData.SZ();
        this.recordData.resetToMark();
        int lenDif = value.length() - oldValue.length();
        this.recordData.cut(oldValue.length() + 1);
        this.recordData.insertBlank(value.length() + 1);
        this.recordData.SZ(value, false);
        this.updateOffsets(idx, lenDif);
        this.updateLinked(idx);
        this.updateNoteOffsets(idx, lenDif);
    }

    public void setLink(int idx, PilotDBRecord linked) throws PalmDbException {
        PilotDBField field = this.getSchema().getField(idx);
        String newValue = linked.getObject(field.linkFieldNum).toString();
        this.setLink(idx, newValue);
    }

    public int getInteger(int fieldIdx) throws PilotDBException {
        this.checkFieldType(fieldIdx, 2);
        this.recordData.position(this.getOffset(fieldIdx));
        return this.recordData.INT();
    }

    public double getFloat(int fieldIdx) throws PilotDBException {
        this.checkFieldType(fieldIdx, 8);
        this.recordData.position(this.getOffset(fieldIdx));
        return this.recordData.DOUBLE();
    }

    public PilotDBTime getTime(int fieldIdx) throws PilotDBException {
        this.checkFieldType(fieldIdx, 4);
        this.recordData.position(this.getOffset(fieldIdx));
        PilotDBTime time = new PilotDBTime(this.recordData.BYTE(), this.recordData.BYTE());
        if (time.isNullTime()) {
            return null;
        }
        return time;
    }

    public PilotDBDate getDate(int fieldIdx) throws PilotDBException {
        this.checkFieldType(fieldIdx, 3);
        this.recordData.position(this.getOffset(fieldIdx));
        PilotDBDate dt = new PilotDBDate(this.recordData.SHORT(), this.recordData.BYTE(), this.recordData.BYTE());
        if (dt.isNullDate()) {
            return null;
        }
        return dt;
    }

    public boolean getBoolean(int fieldIdx) throws PilotDBException {
        this.checkFieldType(fieldIdx, 1);
        this.recordData.position(this.getOffset(fieldIdx));
        return this.recordData.BYTE() != 0;
    }

    public Object getObject(String colName) throws PilotDBException {
        int index = this.getSchema().getFieldIndex(colName);
        return this.getObject(index);
    }

    public Object getObject(int idx) throws PilotDBException {
        Object obj = null;
        PilotDBField field = this.getSchema().getField(idx);
        if (field.type == 2) {
            obj = new Integer(this.getInteger(idx));
        } else if (field.type == 0) {
            obj = this.getString(idx);
        } else if (field.type == 1) {
            obj = new Boolean(this.getBoolean(idx));
        } else if (field.type == 3) {
            obj = this.getDate(idx);
        } else if (field.type == 4) {
            obj = this.getTime(idx);
        } else if (field.type == 6) {
            obj = this.getListChoice(idx);
        } else if (field.type == 8) {
            obj = new Float(this.getFloat(idx));
        } else if (field.type == 7) {
            obj = this.getLinkText(idx);
        } else if (field.type == 10) {
            obj = this.getLinked(idx);
        } else if (field.type == 5) {
            obj = this.getNote(idx);
        } else if (field.type == 9) {
            obj = this.getCalculatedText(idx);
        }
        return obj;
    }

    public void setBoolean(int idx, String val) throws Exception {
        String possible = "|Y|YES|TRUE|T|";
        String testValue = "|" + val.toUpperCase() + "|";
        if (possible.indexOf(testValue) > -1) {
            this.setBoolean(idx, true);
        } else {
            this.setBoolean(idx, false);
        }
    }

    public void setDate(int idx, String val) throws Exception {
        this.setDate(idx, new PilotDBDate(val));
    }

    public void setFloat(int idx, String val) throws Exception {
        this.setFloat(idx, Float.parseFloat(val));
    }

    public void setInteger(int idx, String val) throws Exception {
        this.setInteger(idx, Integer.parseInt(val));
    }

    public void setDelimitedNote(int idx, String val) throws Exception {
        String title = null;
        String content = null;
        if (val.indexOf("\n") < 0) {
            title = "No Title";
            content = val;
        } else {
            title = val.substring(0, val.indexOf("\n"));
            content = String.valueOf(title) + "\n" + val.substring(val.indexOf("\n") + 1);
        }
        this.setNoteTitle(idx, title);
        this.setNote(idx, content);
    }

    public void setTime(int idx, String val) throws Exception {
        this.setTime(idx, new PilotDBTime(val));
    }

    public void setObject(int idx, Object obj) throws Exception {
        PilotDBField field = this.getSchema().getField(idx);
        if (field.type == 2) {
            this.setInteger(idx, obj.toString());
        } else if (field.type == 0) {
            this.setString(idx, obj.toString());
        } else if (field.type == 1) {
            this.setBoolean(idx, obj.toString());
        } else if (field.type == 3) {
            this.setDate(idx, obj.toString());
        } else if (field.type == 4) {
            this.setTime(idx, obj.toString());
        } else if (field.type == 6) {
            this.setList(idx, obj.toString());
        } else if (field.type == 8) {
            this.setFloat(idx, obj.toString());
        } else if (field.type == 7) {
            this.setLink(idx, obj.toString());
        } else if (field.type == 5) {
            this.setDelimitedNote(idx, obj.toString());
        }
    }

    public String getNoteTitle(int fieldIdx) throws PilotDBException {
        this.checkFieldType(fieldIdx, 5);
        this.dirty();
        this.recordData.position(this.getOffset(fieldIdx));
        return this.recordData.SZ();
    }

    public String getNote(int fieldIdx) throws PilotDBException {
        this.checkFieldType(fieldIdx, 5);
        this.recordData.position(this.getOffset(fieldIdx));
        this.recordData.SZ();
        short noteOffset = this.recordData.SHORT();
        if (noteOffset == 0) {
            return null;
        }
        this.recordData.position(noteOffset);
        return this.recordData.SZ();
    }

    public String getString(int fieldIdx) throws PilotDBException {
        this.checkFieldType(fieldIdx, 0);
        this.recordData.position(this.getOffset(fieldIdx));
        return this.recordData.SZ();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int fc = this.getSchema().getFieldCount();
        try {
            int i = 0;
            while (i < fc) {
                PilotDBField field = this.getSchema().getField(i);
                sb.append("[" + field.name + "(" + PilotDBField.FIELD_TYPE_NAMES[field.getType()] + ") - " + this.getObject(i) + "] ");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            sb.append(e);
        }
        return sb.toString();
    }

    public PilotDBSchema getSchema() {
        return this.getDb().getSchema();
    }

    private final void updateOffsets(int afterField, int amount) {
        int i = afterField + 1;
        while (i < this.getOffsetCount()) {
            this.setOffset(i, (short)(this.getOffset(i) + amount));
            ++i;
        }
    }

    public void updateCalculated(int i, EvaluationContext ctx) throws PilotDBException {
        int offset = this.getOffset(i);
        this.recordData.position(offset).mark();
        byte fieldType = this.recordData.BYTE();
        this.recordData.position(offset);
        switch (fieldType) {
            case 2: {
                this.updateOffsets(i, -5);
                this.recordData.position(offset);
                this.recordData.cut(5);
                break;
            }
            case 8: {
                this.updateOffsets(i, -9);
                this.recordData.position(offset);
                this.recordData.cut(9);
                break;
            }
            case 3: {
                this.updateOffsets(i, -5);
                this.recordData.position(offset);
                this.recordData.cut(5);
                break;
            }
            case 4: {
                this.updateOffsets(i, -3);
                this.recordData.position(offset);
                this.recordData.cut(3);
                break;
            }
            case 0: {
                String oldData = this.recordData.SZ();
                this.updateOffsets(i, -(oldData.length() + 2));
                this.recordData.position(offset);
                this.recordData.cut(oldData.length() + 2);
            }
        }
        ctx.setRecord(this);
        PilotDBField field = this.getSchema().getField(i);
        int type = field.getScript().getType(ctx);
        this.recordData.position(offset);
        switch (type) {
            case 2: {
                this.recordData.insertBlank(5);
                this.recordData.BYTE((byte)2, false);
                int mark = this.recordData.position();
                int value = field.getScript().getInt(ctx);
                this.recordData.position(mark);
                this.recordData.INT(value, false);
                this.updateOffsets(i, 5);
                break;
            }
            case 8: {
                this.recordData.insertBlank(9);
                this.recordData.BYTE((byte)8, false);
                this.recordData.DOUBLE(field.getScript().getFloat(ctx), false);
                this.updateOffsets(i, 9);
                break;
            }
            case 3: {
                PilotDBDate dt = field.getScript().getDate(ctx);
                this.recordData.insertBlank(5);
                this.recordData.BYTE((byte)3, false);
                this.recordData.SHORT(dt.getYear(), false);
                this.recordData.BYTE((byte)dt.getMonth(), false);
                this.recordData.BYTE((byte)dt.getDate(), false);
                this.updateOffsets(i, 5);
                break;
            }
            case 4: {
                PilotDBTime tm = field.getScript().getTime(ctx);
                this.recordData.insertBlank(3);
                this.recordData.BYTE((byte)4, false);
                this.recordData.BYTE((byte)tm.getHour(), false);
                this.recordData.BYTE((byte)tm.getMinute(), false);
                this.updateOffsets(i, 3);
                break;
            }
            case 0: {
                String s = field.getScript().getString(ctx);
                this.recordData.insertBlank(1 + s.length() + 1);
                this.recordData.BYTE((byte)0, false);
                this.recordData.SZ(s, false);
                this.updateOffsets(i, 2 + s.length());
                break;
            }
            default: {
                throw new RuntimeException("invalid type");
            }
        }
    }

    public int getId() {
        return this.recordHeader.uniqueId;
    }

    public void setId(int id) {
        this.recordHeader.uniqueId = id;
    }
}

