/*
 * Decompiled with CFR 0.152.
 */
package pilotdb;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import palmdb.PalmPreferences;
import pilotdb.DateTimeFormatException;

public class PilotDBTime
implements Comparable,
Cloneable {
    int hour;
    int minute;

    public PilotDBTime() {
        Calendar c = Calendar.getInstance();
        this.hour = c.get(11);
        this.minute = c.get(12);
    }

    public PilotDBTime(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        this.hour = c.get(11);
        this.minute = c.get(12);
    }

    public PilotDBTime(String val) throws DateTimeFormatException {
        DateFormat df = PalmPreferences.getInstance().getPalmTimeFormat().getJavaTimeFormat();
        try {
            Date d = df.parse(val);
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            this.hour = c.get(11);
            this.minute = c.get(12);
        }
        catch (ParseException pe) {
            throw new DateTimeFormatException(val, PalmPreferences.getInstance().getPalmTimeFormat().getPalmTimeFormat());
        }
        if (this.hour < 0 || this.hour > 23) {
            throw new DateTimeFormatException(val, "0-23");
        }
        if (this.minute < 0 || this.minute > 59) {
            throw new DateTimeFormatException(val, "0-59");
        }
    }

    public PilotDBTime(int hour, int minute) {
        this.hour = hour;
        this.minute = minute;
    }

    public Date toDate() {
        Calendar c = Calendar.getInstance();
        c.set(11, this.hour);
        c.set(12, this.minute);
        return c.getTime();
    }

    public String toString() {
        if (this.isNullTime()) {
            return "n/a";
        }
        return PalmPreferences.getInstance().getPalmTimeFormat().getJavaTimeFormat().format(this.toDate());
    }

    public boolean isNullTime() {
        return this.hour == 24 && this.minute == 0;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 instanceof PilotDBTime) {
            PilotDBTime rhs = (PilotDBTime)arg0;
            return rhs.hour == this.hour && rhs.minute == this.minute;
        }
        return super.equals(arg0);
    }

    public int compareTo(Object o) {
        if (o instanceof PilotDBTime) {
            PilotDBTime rhs = (PilotDBTime)o;
            Integer ithis = new Integer(this.hour * 60 + this.minute);
            Integer irhs = new Integer(rhs.hour * 60 + this.minute);
            return ithis.compareTo(irhs);
        }
        return this.toString().compareTo(String.valueOf(o));
    }

    public Object clone() {
        PilotDBTime tm = new PilotDBTime();
        tm.hour = this.hour;
        tm.minute = this.minute;
        return tm;
    }
}

