/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import palmdb.util.ByteArray;
import pilotdb.PilotDBException;
import pilotdb.calc.AbstractOperation;
import pilotdb.calc.EvaluationContext;

public class ArithmeticOperation
extends AbstractOperation {
    short group3Spec;

    public ArithmeticOperation(short group3Spec) {
        this.group3Spec = group3Spec;
    }

    public int getType(EvaluationContext ctx) throws PilotDBException {
        int i = 0;
        while (i < this.getArgumentCount()) {
            if (this.getArgument(i).getType(ctx) == 8) {
                return 8;
            }
            ++i;
        }
        return 2;
    }

    public void toByteCode(EvaluationContext ctx, ByteArray byteArray) throws PilotDBException {
        byteArray.BYTE((byte)2, true);
        byteArray.BYTE((byte)this.group3Spec, true);
        if (this.getType(ctx) == 8) {
            byteArray.BYTE((byte)65, true);
        } else {
            byteArray.BYTE((byte)64, true);
        }
        int i = 0;
        while (i < this.getArgumentCount()) {
            this.getArgument(i).toByteCode(ctx, byteArray);
            ++i;
        }
        byteArray.BYTE((byte)3, true);
    }

    public void toScript(EvaluationContext ctx, StringBuffer stringBuffer) {
        stringBuffer.append("(");
        switch (this.group3Spec) {
            case 0: {
                stringBuffer.append("+");
                break;
            }
            case 1: {
                stringBuffer.append("-");
                break;
            }
            case 2: {
                stringBuffer.append("*");
                break;
            }
            case 3: {
                stringBuffer.append("/");
            }
        }
        int i = 0;
        while (i < this.getArgumentCount()) {
            stringBuffer.append(" ");
            this.getArgument(i).toScript(ctx, stringBuffer);
            ++i;
        }
        stringBuffer.append(")");
    }

    public int getInt(EvaluationContext ctx) throws PilotDBException {
        int val = this.getArgument(0).getInt(ctx);
        int i = 1;
        while (i < this.getArgumentCount()) {
            int b = this.getArgument(i).getInt(ctx);
            switch (this.group3Spec) {
                case 0: {
                    val += b;
                    break;
                }
                case 1: {
                    val -= b;
                    break;
                }
                case 2: {
                    val *= b;
                    break;
                }
                case 3: {
                    val /= b;
                    break;
                }
                default: {
                    throw new RuntimeException("group3Spec not set");
                }
            }
            ++i;
        }
        return val;
    }

    public double getFloat(EvaluationContext ctx) throws PilotDBException {
        double val = this.getArgument(0).getFloat(ctx);
        int i = 1;
        while (i < this.getArgumentCount()) {
            double b = this.getArgument(i).getFloat(ctx);
            switch (this.group3Spec) {
                case 0: {
                    val += b;
                    break;
                }
                case 1: {
                    val -= b;
                    break;
                }
                case 2: {
                    val *= b;
                    break;
                }
                case 3: {
                    val /= b;
                    break;
                }
                default: {
                    throw new RuntimeException("group3Spec not set");
                }
            }
            ++i;
        }
        return val;
    }

    public String getString(EvaluationContext ctx) {
        return null;
    }
}

