/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import java.util.Stack;
import palmdb.util.ByteArray;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBTime;
import pilotdb.calc.AbstractOperation;
import pilotdb.calc.AllOperation;
import pilotdb.calc.AndOperation;
import pilotdb.calc.ArithmeticOperation;
import pilotdb.calc.BranchOperation;
import pilotdb.calc.ByteCodeConstants;
import pilotdb.calc.DateLiteral;
import pilotdb.calc.DurCastOperation;
import pilotdb.calc.EvaluationContext;
import pilotdb.calc.FieldExpression;
import pilotdb.calc.FieldFromRecordOperation;
import pilotdb.calc.FloatLiteral;
import pilotdb.calc.IntCastOperation;
import pilotdb.calc.IntegerLiteral;
import pilotdb.calc.InvalidCodeException;
import pilotdb.calc.NotOperation;
import pilotdb.calc.NumberComparisonOperation;
import pilotdb.calc.Operation;
import pilotdb.calc.OrOperation;
import pilotdb.calc.RandomOperation;
import pilotdb.calc.Script;
import pilotdb.calc.SortOperation;
import pilotdb.calc.StringComparisonOperation;
import pilotdb.calc.StringLiteral;
import pilotdb.calc.TestOperation;
import pilotdb.calc.TimeLiteral;

public class ByteCodeExpressionParser
implements ByteCodeConstants {
    Stack opStack = new Stack();
    Operation currentOp = null;

    public Script parse(EvaluationContext context, ByteArray byteCode) throws InvalidCodeException {
        try {
            Script script = new Script();
            this.opStack.clear();
            this.currentOp = null;
            Operation op = null;
            byteCode.reset();
            while (byteCode.hasMoreBytes()) {
                short tag = byteCode.UBYTE();
                switch (tag) {
                    case 1: {
                        short opCodeGroup2 = byteCode.UBYTE();
                        op = this.createOperation(opCodeGroup2);
                        if (this.currentOp != null) {
                            this.currentOp.addArgument(op);
                            this.opStack.push(this.currentOp);
                        }
                        this.currentOp = op;
                        break;
                    }
                    case 2: {
                        short opCodeGroup3 = byteCode.UBYTE();
                        short opCodeGroup1 = byteCode.UBYTE();
                        op = this.createOperation(opCodeGroup1, opCodeGroup3);
                        if (this.currentOp != null) {
                            this.currentOp.addArgument(op);
                            this.opStack.push(this.currentOp);
                        }
                        this.currentOp = op;
                        break;
                    }
                    case 3: {
                        if (!this.opStack.empty()) {
                            this.currentOp = (Operation)this.opStack.pop();
                            break;
                        }
                        if (this.currentOp instanceof SortOperation) {
                            script.setSortOperation((SortOperation)this.currentOp);
                            break;
                        }
                        script.setTypedOperation(this.currentOp);
                        break;
                    }
                    case 5: {
                        short fieldId = byteCode.UBYTE();
                        FieldExpression fieldExpression = new FieldExpression(fieldId);
                        this.currentOp.addArgument(fieldExpression);
                        break;
                    }
                    case 6: {
                        String s = byteCode.SZ();
                        StringLiteral sl = new StringLiteral(s);
                        this.currentOp.addArgument(sl);
                        break;
                    }
                    case 7: {
                        int value = byteCode.INT();
                        this.currentOp.addArgument(new IntegerLiteral(value));
                        break;
                    }
                    case 8: {
                        double fvalue = byteCode.DOUBLE();
                        this.currentOp.addArgument(new FloatLiteral(fvalue));
                        break;
                    }
                    case 9: {
                        short year = byteCode.SHORT();
                        byte month = byteCode.BYTE();
                        byte date = byteCode.BYTE();
                        this.currentOp.addArgument(new DateLiteral(new PilotDBDate(year, month, date)));
                        break;
                    }
                    case 10: {
                        byte hour = byteCode.BYTE();
                        byte minute = byteCode.BYTE();
                        this.currentOp.addArgument(new TimeLiteral(new PilotDBTime(hour, minute)));
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Not yet implemented");
                    }
                }
            }
            return script;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidCodeException(e.toString());
        }
    }

    private int getOpCode(int operation) throws InvalidCodeException {
        switch (this.getGroup(operation)) {
            case 64: {
                return operation - 64;
            }
            case 128: {
                return operation - 128;
            }
        }
        throw new InvalidCodeException("Invalid operation code:" + operation);
    }

    private int getGroup(int operation) throws InvalidCodeException {
        if ((operation & 0x40) == 64) {
            return 64;
        }
        if ((operation & 0x80) == 128) {
            return 128;
        }
        throw new InvalidCodeException("Invalid operation code:" + operation);
    }

    private Operation createOperation(int opCodeGroup2) throws InvalidCodeException {
        AbstractOperation op = null;
        switch (opCodeGroup2 - 128) {
            case 0: {
                op = new AndOperation();
                break;
            }
            case 1: {
                op = new OrOperation();
                break;
            }
            case 2: {
                op = new AllOperation();
                break;
            }
            case 3: {
                op = new BranchOperation();
                break;
            }
            case 4: {
                op = new TestOperation();
                break;
            }
            case 5: {
                op = new NotOperation();
                break;
            }
            case 7: {
                op = new SortOperation();
                break;
            }
            case 6: {
                op = new FieldFromRecordOperation();
                break;
            }
            case 8: {
                op = new IntCastOperation();
                break;
            }
            case 9: {
                op = new DurCastOperation();
                break;
            }
            default: {
                throw new InvalidCodeException("Invalid group2 opcode:" + (opCodeGroup2 - 128));
            }
        }
        return op;
    }

    private Operation createOperation(short opCodeGroup1, short opCodeGroup3) throws InvalidCodeException {
        AbstractOperation op = null;
        block0 : switch (opCodeGroup1 - 64) {
            case 0: 
            case 1: {
                op = new ArithmeticOperation(opCodeGroup3);
                break;
            }
            case 5: {
                switch (opCodeGroup3) {
                    case 11: {
                        op = new RandomOperation();
                        break block0;
                    }
                }
                throw new InvalidCodeException("not yet implemented");
            }
            case 2: {
                switch (opCodeGroup3) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        op = new NumberComparisonOperation(opCodeGroup3);
                        break block0;
                    }
                }
                throw new RuntimeException("not yet implemented");
            }
            case 3: {
                switch (opCodeGroup3) {
                    case 9: 
                    case 10: {
                        op = new StringComparisonOperation(opCodeGroup3);
                    }
                }
                break;
            }
            default: {
                throw new InvalidCodeException("not yet implemented");
            }
        }
        return op;
    }
}

