/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import palmdb.util.ByteArray;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBException;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBTime;
import pilotdb.calc.AbstractExpression;
import pilotdb.calc.EvaluationContext;

public class FieldExpression
extends AbstractExpression {
    private int fieldIndex = -1;

    public FieldExpression(int fieldIndex) {
        this.fieldIndex = fieldIndex;
    }

    public PilotDBDate getDate(EvaluationContext ctx) throws PilotDBException {
        return ctx.getRecord().getDate(this.fieldIndex);
    }

    public double getFloat(EvaluationContext ctx) throws PilotDBException {
        PilotDBRecord r = ctx.getRecord();
        int type = r.getSchema().getField(this.fieldIndex).getType();
        switch (type) {
            case 1: {
                if (r.getBoolean(this.fieldIndex)) {
                    return 1.0;
                }
                return 0.0;
            }
            case 8: {
                return r.getFloat(this.fieldIndex);
            }
            case 2: {
                return r.getInteger(this.fieldIndex);
            }
        }
        throw new RuntimeException("Don't know how to convert a type " + type + " into a float");
    }

    public int getInt(EvaluationContext ctx) throws PilotDBException {
        switch (this.getType(ctx)) {
            case 2: {
                return ctx.getRecord().getInteger(this.fieldIndex);
            }
            case 1: {
                if (ctx.getRecord().getBoolean(this.fieldIndex)) {
                    return 1;
                }
                return 0;
            }
            case 8: {
                return (int)this.getFloat(ctx);
            }
        }
        throw new RuntimeException("invalid type");
    }

    public String getString(EvaluationContext ctx) throws PilotDBException {
        switch (this.getType(ctx)) {
            case 5: {
                return ctx.getRecord().getNoteTitle(this.fieldIndex);
            }
            case 0: {
                return ctx.getRecord().getString(this.fieldIndex);
            }
            case 6: {
                return ctx.getRecord().getListChoice(this.fieldIndex);
            }
            case 7: {
                return ctx.getRecord().getLinkText(this.fieldIndex);
            }
            case 10: {
                return ctx.getRecord().getLinked(this.fieldIndex);
            }
            case 1: 
            case 2: {
                return String.valueOf(this.getInt(ctx));
            }
            case 3: {
                return String.valueOf(this.getDate(ctx));
            }
            case 4: {
                return String.valueOf(this.getTime(ctx));
            }
            case 8: {
                return String.valueOf(this.getFloat(ctx));
            }
        }
        throw new RuntimeException("invalid type");
    }

    public PilotDBTime getTime(EvaluationContext ctx) throws PilotDBException {
        return ctx.getRecord().getTime(this.fieldIndex);
    }

    public int getType(EvaluationContext ctx) {
        int type = ctx.getSchema().getField(this.fieldIndex).getType();
        switch (type) {
            case 0: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                return 0;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 8;
            }
        }
        return type;
    }

    public void toByteCode(EvaluationContext ctx, ByteArray byteArray) {
        byteArray.BYTE((byte)5, true);
        byteArray.BYTE((byte)this.fieldIndex, true);
    }

    public void toScript(EvaluationContext ctx, StringBuffer stringBuffer) {
        stringBuffer.append("%").append(this.fieldIndex);
    }
}

