/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import palmdb.util.ByteArray;
import pilotdb.calc.AbstractExpression;
import pilotdb.calc.EvaluationContext;

public class FloatLiteral
extends AbstractExpression {
    double floatValue;

    public FloatLiteral(double f) {
        this.floatValue = f;
    }

    public double getFloat(EvaluationContext ctx) {
        return this.floatValue;
    }

    public int getType(EvaluationContext ctx) {
        return 8;
    }

    public void toByteCode(EvaluationContext ctx, ByteArray byteArray) {
        byteArray.BYTE((byte)8, true).DOUBLE(this.floatValue, true);
    }

    public void toScript(EvaluationContext ctx, StringBuffer stringBuffer) {
        stringBuffer.append(String.valueOf(this.floatValue));
    }

    public int getInt(EvaluationContext ctx) {
        return (int)this.floatValue;
    }

    public String getString(EvaluationContext ctx) {
        return String.valueOf(this.getInt(ctx));
    }
}

