/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import palmdb.util.ByteArray;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBException;
import pilotdb.PilotDBTime;
import pilotdb.calc.AbstractOperation;
import pilotdb.calc.EvaluationContext;
import pilotdb.calc.Expression;

public class IntCastOperation
extends AbstractOperation {
    public int getType(EvaluationContext ctx) {
        return 2;
    }

    public void toByteCode(EvaluationContext ctx, ByteArray byteArray) {
    }

    public void toScript(EvaluationContext ctx, StringBuffer stringBuffer) {
    }

    public int getInt(EvaluationContext ctx) throws PilotDBException {
        Expression e = this.getArgument(0);
        switch (e.getType(ctx)) {
            case 4: {
                PilotDBTime time = e.getTime(ctx);
                return time.getHour() * 60 + time.getMinute();
            }
            case 3: {
                PilotDBDate dt = e.getDate(ctx);
                PilotDBDate dtstd = new PilotDBDate(1904, 1, 1);
                return (int)((dt.toDate().getTime() - dtstd.toDate().getTime()) / 1000L);
            }
            case 8: {
                return (int)e.getFloat(ctx);
            }
            case 0: {
                if (e.getString(ctx) != null) {
                    return 1;
                }
                return 0;
            }
            case 2: {
                return e.getInt(ctx);
            }
        }
        throw new RuntimeException("can't (int) cast type:" + e.getType(ctx));
    }

    public String getString(EvaluationContext ctx) throws PilotDBException {
        return String.valueOf(this.getInt(ctx));
    }
}

