/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import palmdb.util.ByteArray;
import pilotdb.PilotDBException;
import pilotdb.calc.AbstractOperation;
import pilotdb.calc.EvaluationContext;

public class StringComparisonOperation
extends AbstractOperation {
    int group3OpCode = 0;

    public StringComparisonOperation(int group3OpCode) {
        this.group3OpCode = group3OpCode;
    }

    public int getType(EvaluationContext ctx) {
        return 2;
    }

    public void toByteCode(EvaluationContext ctx, ByteArray byteArray) throws PilotDBException {
        byteArray.BYTE((byte)2, true);
        byteArray.BYTE((byte)this.group3OpCode, true);
        byteArray.BYTE((byte)67, true);
        int i = 0;
        while (i < this.getArgumentCount()) {
            this.getArgument(i).toByteCode(ctx, byteArray);
            ++i;
        }
        byteArray.BYTE((byte)3, true);
    }

    public void toScript(EvaluationContext ctx, StringBuffer stringBuffer) {
        stringBuffer.append("(");
        switch (this.group3OpCode) {
            case 9: {
                stringBuffer.append("seq");
                break;
            }
            case 10: {
                stringBuffer.append("sstr");
            }
        }
        int i = 0;
        while (i < this.getArgumentCount()) {
            stringBuffer.append(" ");
            this.getArgument(i).toScript(ctx, stringBuffer);
            ++i;
        }
        stringBuffer.append(")");
    }

    public double getFloat(EvaluationContext ctx) throws PilotDBException {
        return this.getInt(ctx);
    }

    public int getInt(EvaluationContext ctx) throws PilotDBException {
        String s1 = this.getArgument(0).getString(ctx);
        String s2 = this.getArgument(1).getString(ctx);
        if (s1 == null && s2 == null) {
            return 1;
        }
        if (s1 == null || s2 == null) {
            return 0;
        }
        switch (this.group3OpCode) {
            case 9: {
                if (s1.equals(s2)) {
                    return 1;
                }
                return 0;
            }
            case 10: {
                if (s1.indexOf(s2) > -1) {
                    return 1;
                }
                return 0;
            }
        }
        throw new RuntimeException("invalid group 3 byte code");
    }

    public String getString(EvaluationContext ctx) throws PilotDBException {
        return String.valueOf(this.getInt(ctx));
    }
}

