/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.conduit;

import java.io.IOException;
import palm.conduit.Log;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palmdb.AppInfo;
import palmdb.BitOps;
import palmdb.PalmDbException;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.conduit.PilotDBSyncAppInfo;
import pilotdb.conduit.PilotDBSyncRecord;

public class PilotDBSyncDatabase
extends PilotDBDatabase {
    int dbHandle;

    public PilotDBSyncDatabase(String name, PilotDBSchema schema) throws Exception {
        super(name, "DB00", "DBOS", schema);
        this.dbHandle = SyncManager.createDB(BitOps.stringToInteger("DBOS"), 0, 0, name, BitOps.stringToInteger("DB00"));
        SyncManager.writeDBAppInfoBlock(this.dbHandle, name, this.getAppInfo().getData());
    }

    public PilotDBSyncDatabase(String name) throws IOException, PalmDbException {
        super((AppInfo)null);
        Log.out("Open Database : " + name);
        this.dbHandle = SyncManager.openDB(name, 0, 224);
        Log.out("Opened Database, dbHandle=" + this.dbHandle);
        byte[] appInfoChunk = SyncManager.readDBAppInfoBlock(this.dbHandle, name);
        this.appInfo = new PilotDBSyncAppInfo(this, appInfoChunk);
        Log.out("Built AppInfo Object");
        int recCount = SyncManager.getDBRecordCount(this.dbHandle);
        Log.out("Record Count:" + recCount);
        int i = 0;
        while (i < recCount) {
            PilotDBSyncRecord syncRecord = new PilotDBSyncRecord(this);
            syncRecord.setIndex(i);
            SyncManager.readRecordByIndex(this.dbHandle, syncRecord);
            this.records.add(syncRecord);
            ++i;
        }
    }

    public int getDBHandle() {
        return this.dbHandle;
    }

    public void close() throws IOException {
        SyncManager.purgeDeletedRecs(this.dbHandle);
        SyncManager.resetSyncFlags(this.dbHandle);
        SyncManager.closeDB(this.dbHandle);
        this.dbHandle = -1;
    }

    public PilotDBRecord createRecord() throws IOException, PalmDbException {
        PilotDBSyncRecord r = new PilotDBSyncRecord(this);
        this.records.add(r);
        return r;
    }

    public PilotDBSyncRecord getSyncRecord(int idx) {
        return (PilotDBSyncRecord)this.records.get(idx);
    }

    protected void finalize() throws Throwable {
        if (this.dbHandle != -1) {
            this.close();
        }
    }

    public void deleteRecord(PilotDBSyncRecord r) throws SyncException {
        super.deleteRecord(r);
        SyncManager.deleteRecord(this.dbHandle, r);
    }
}

