/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools;

import java.io.FileInputStream;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBField;

public class SimpleDBInfo {
    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.err.println("Usage java pilotdb.tools.SimpleDBInfo <filename>");
                System.exit(1);
            }
            String pdbFileName = args[0];
            PilotDBDatabase db = new PilotDBDatabase(new FileInputStream(pdbFileName));
            System.out.println("Database Info");
            System.out.println("------------------------");
            System.out.println("Name: " + db.getTitle());
            System.out.println("Column Count: " + db.getSchema().getFieldCount());
            int count = db.getSchema().getFieldCount();
            int i = 0;
            while (i < count) {
                PilotDBField field = db.getSchema().getField(i);
                SimpleDBInfo.printField(i, field);
                SimpleDBInfo.p("------------------");
                ++i;
            }
            SimpleDBInfo.p("");
            SimpleDBInfo.p("");
            SimpleDBInfo.p("");
            SimpleDBInfo.p("Record Count: " + db.getRecordCount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printField(int idx, PilotDBField field) {
        SimpleDBInfo.p("Field " + idx + " Name: " + field.getName());
        switch (field.getType()) {
            case 1: {
                SimpleDBInfo.p("Field type: boolean");
                break;
            }
            case 3: {
                SimpleDBInfo.p("Field type: date");
                if (field.getDefaultDate() == null) break;
                SimpleDBInfo.p("Default: " + field.getDefaultDate());
                break;
            }
            case 8: {
                SimpleDBInfo.p("Field type: float");
                SimpleDBInfo.p("Default: " + field.getDefaultDouble());
                break;
            }
            case 2: {
                SimpleDBInfo.p("Field type: integer");
                SimpleDBInfo.p("Default: " + field.getDefaultInteger());
                SimpleDBInfo.p("Increment: " + field.getIncrement());
                break;
            }
            case 0: {
                SimpleDBInfo.p("Field type: string");
                SimpleDBInfo.p("Default: " + field.getDefaultString());
                break;
            }
            case 4: {
                SimpleDBInfo.p("Field type: time");
                if (field.getDefaultTime() == null) break;
                SimpleDBInfo.p("Default: " + field.getDefaultTime());
                break;
            }
            case 6: {
                SimpleDBInfo.p("Field type: list");
                int i = 0;
                while (i < field.getListChoiceCount()) {
                    SimpleDBInfo.p("Choice " + i + ": " + field.getListChoice(i));
                    ++i;
                }
                break;
            }
            case 7: {
                SimpleDBInfo.p("Field type: link");
                SimpleDBInfo.p("Link Table: " + field.getLinkTable());
                SimpleDBInfo.p("Link Column Number: " + field.getLinkColumnNumber());
                break;
            }
            case 10: {
                SimpleDBInfo.p("Field type: linked");
                SimpleDBInfo.p("Linked Field: " + field.getLinkedLinkFieldIndex());
                SimpleDBInfo.p("Linked Table Column: " + field.getLinkedTableColumnIndex());
            }
        }
    }

    private static final void p(Object obj) {
        System.out.println(obj);
    }
}

