/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools.export.csv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.tools.AbstractPlugin;
import pilotdb.tools.simplecreator.csv.CSVImportModel;

public class Plugin
extends AbstractPlugin {
    private String outputCsvPath;
    private String outputIfoPath;
    private String pdbPath;
    private PilotDBDatabase database = null;

    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("output-csv");
        OptionBuilder.withDescription("the csv output file");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("output-csv");
        Option o = OptionBuilder.create("o");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("output-ifo");
        OptionBuilder.withDescription("the ifo output file");
        OptionBuilder.withLongOpt("output-ifo");
        Option c = OptionBuilder.create("c");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("input");
        OptionBuilder.withDescription("the pdb file");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("input-file");
        Option p = OptionBuilder.create("p");
        options.addOption(o);
        options.addOption(c);
        options.addOption(p);
        return options;
    }

    public void configure(CommandLine line) {
        try {
            this.setOutputCsvPath(line.getOptionValue("o"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
        String p = line.getOptionValue("c");
        if (p != null) {
            try {
                this.setOutputIfoPath(line.getOptionValue("c"));
            }
            catch (Exception e) {
                this.addError(e.getMessage(), new Object[0]);
            }
        }
        try {
            this.setPdbPath(line.getOptionValue("p"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
    }

    public boolean isReady() {
        return this.outputCsvPath != null && this.outputIfoPath != null && this.pdbPath != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws Exception {
        if (this.database == null) {
            throw new Exception("Database is not set");
        }
        try {
            this.start();
            CSVImportModel model = new CSVImportModel(this.database);
            File ifoFile = new File(this.outputIfoPath);
            FileWriter writer = new FileWriter(ifoFile);
            model.write(writer);
            writer.close();
            File csvFile = new File(this.outputCsvPath);
            writer = new FileWriter(csvFile);
            BufferedWriter bw = new BufferedWriter(writer);
            int recordcount = this.database.getRecordCount();
            this.setSteps(recordcount);
            PilotDBSchema schema = this.database.getSchema();
            int i = 0;
            block3: while (true) {
                block8: {
                    if (i < recordcount) break block8;
                    bw.close();
                    break;
                }
                this.setStep(i + 1, "Exporting Record " + (i + 1));
                PilotDBRecord rec = (PilotDBRecord)this.database.getRecord(i);
                StringBuffer sb = new StringBuffer();
                int j = 0;
                while (true) {
                    if (j >= schema.getFieldCount()) {
                        bw.write(sb.toString());
                        bw.newLine();
                        ++i;
                        continue block3;
                    }
                    if (j > 0) {
                        sb.append(",");
                    }
                    Object value = rec.getObject(j);
                    sb.append(this.quoted(String.valueOf(value)));
                    ++j;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.done();
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        this.done();
    }

    private String quoted(String in) {
        return "\"".concat(in).concat("\"");
    }

    public String getOutputCsvPath() {
        return this.outputCsvPath;
    }

    public String getOutputIfoPath() {
        return this.outputIfoPath;
    }

    public String getPdbPath() {
        return this.pdbPath;
    }

    public void setOutputCsvPath(String string) {
        this.outputCsvPath = string;
    }

    public void setOutputIfoPath(String string) {
        this.outputIfoPath = string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPdbPath(String string) {
        this.pdbPath = string;
        File f = new File(this.pdbPath);
        if (f.exists() && f.canRead()) {
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(f);
                    this.database = new PilotDBDatabase(fis);
                }
                catch (Exception e) {
                    this.addError("{0} is not a valid Pilot-DB", new Object[]{this.pdbPath});
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                try {}
                catch (Exception exception) {
                    return;
                }
                fis.close();
                return;
            }
        }
        this.addError("{0} does not exists or is not readable", new Object[]{this.pdbPath});
    }

    public void setDatabase(PilotDBDatabase selectedDb) {
        this.database = selectedDb;
    }
}

