/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools.export.xls;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.tools.AbstractPlugin;

public class Plugin
extends AbstractPlugin {
    private String outputCsvPath;
    private String pdbPath;
    private PilotDBDatabase database = null;

    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("output-xls");
        OptionBuilder.withDescription("the xls output file");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("output-xls");
        Option o = OptionBuilder.create("o");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("input");
        OptionBuilder.withDescription("the pdb file");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("input-file");
        Option p = OptionBuilder.create("p");
        options.addOption(o);
        options.addOption(p);
        return options;
    }

    public void configure(CommandLine line) {
        try {
            this.setOutputCsvPath(line.getOptionValue("o"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
        try {
            this.setPdbPath(line.getOptionValue("p"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
    }

    public boolean isReady() {
        return this.outputCsvPath != null && this.pdbPath != null;
    }

    public void execute() throws Exception {
        if (this.database == null) {
            throw new Exception("Database is not set");
        }
        FileOutputStream fileOut = new FileOutputStream(this.outputCsvPath);
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(this.database.getTitle());
        PilotDBSchema schema = this.database.getSchema();
        HSSFRow row = sheet.createRow(0);
        int c = 0;
        while (c < schema.getFieldCount()) {
            row.createCell((short)c).setCellValue(schema.getField(c).getName());
            ++c;
        }
        int i = 0;
        while (i < this.database.getRecordCount()) {
            PilotDBRecord rec = (PilotDBRecord)this.database.getRecord(i);
            row = sheet.createRow((short)i + 1);
            int c2 = 0;
            while (c2 < schema.getFieldCount()) {
                row.createCell((short)c2).setCellValue(String.valueOf(rec.getObject(c2)));
                ++c2;
            }
            ++i;
        }
        wb.write(fileOut);
        fileOut.close();
    }

    private String quoted(String in) {
        return "\"".concat(in).concat("\"");
    }

    public String getOutputCsvPath() {
        return this.outputCsvPath;
    }

    public String getPdbPath() {
        return this.pdbPath;
    }

    public void setOutputCsvPath(String string) {
        this.outputCsvPath = string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPdbPath(String string) {
        this.pdbPath = string;
        File f = new File(this.pdbPath);
        if (f.exists() && f.canRead()) {
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(f);
                    this.database = new PilotDBDatabase(fis);
                }
                catch (Exception e) {
                    this.addError("{0} is not a valid Pilot-DB", new Object[]{this.pdbPath});
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                try {}
                catch (Exception exception) {
                    return;
                }
                fis.close();
                return;
            }
        }
        this.addError("{0} does not exists or is not readable", new Object[]{this.pdbPath});
    }

    public void setDatabase(PilotDBDatabase selectedDb) {
        this.database = selectedDb;
    }
}

