/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools.simplecreator.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBField;
import pilotdb.PilotDBSchema;
import pilotdb.util.StringUtils;

public class CSVImportModel {
    public static final String[] SUPPORTED_TYPES = new String[]{"string", "integer", "float", "date", "time", "boolean"};
    public static final int[] SUPPORTED_TYPES_INT;
    private String databaseTitle;
    private String databasePath;
    private String csvPath;
    private String creatorId = "DBOS";
    private String timeFormat = "%H:%M";
    private String dateFormat = "%Y/%m/%d";
    private char separator = (char)44;
    private boolean globalFind;
    private boolean readOnly;
    private boolean protectedDb;
    private boolean backup;
    private boolean copyPrevention;
    private boolean extendedCsvFormat = true;
    private List views = new LinkedList();
    private List tableFields = new LinkedList();

    static {
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 8;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 1;
        SUPPORTED_TYPES_INT = nArray;
    }

    public CSVImportModel(PilotDBDatabase database) {
        this.databaseTitle = database.getTitle();
        int viewCount = database.getViewCount();
        int i = 0;
        while (i < viewCount) {
            View v = new View();
            v.name = database.getView(i).getName();
            int fieldCount = database.getView(i).getColumnCount();
            int j = 0;
            while (j < fieldCount) {
                int tableFieldIndex = database.getView(i).getColumn(j).getFieldNumber();
                ViewField vf = new ViewField();
                vf.name = database.getSchema().getField(tableFieldIndex).getName();
                vf.width = database.getView(i).getColumn(j).getFieldWidth();
                v.fields.add(vf);
                ++j;
            }
            this.views.add(v);
            ++i;
        }
        PilotDBSchema s = database.getSchema();
        int i2 = 0;
        while (i2 < s.getFieldCount()) {
            PilotDBField field = s.getField(i2);
            TableField tf = new TableField();
            tf.def = field.getDefaultString();
            tf.name = field.getName();
            tf.type = field.getType();
            this.tableFields.add(tf);
            ++i2;
        }
    }

    public CSVImportModel() {
    }

    public View getView(String name) {
        int i = 0;
        while (i < this.views.size()) {
            View v = (View)this.views.get(i);
            if (v.name.equals(name)) {
                return v;
            }
            ++i;
        }
        return null;
    }

    public void write(Writer fw) throws IOException {
        this.newline(fw);
        fw.write("title");
        this.space(fw);
        this.quoted(fw, this.databaseTitle);
        int i = 0;
        while (i < this.tableFields.size()) {
            this.newline(fw);
            TableField tf = (TableField)this.tableFields.get(i);
            fw.write("field");
            this.space(fw);
            this.quoted(fw, tf.name);
            this.space(fw);
            switch (tf.type) {
                case 1: {
                    fw.write("boolean");
                    if (tf.def == null) break;
                    this.space(fw);
                    fw.write(tf.def);
                    break;
                }
                case 2: {
                    fw.write("integer");
                    if (tf.def == null) break;
                    this.space(fw);
                    fw.write(tf.def);
                    break;
                }
                case 8: {
                    fw.write("float");
                    if (tf.def == null) break;
                    this.space(fw);
                    fw.write(tf.def);
                    break;
                }
                case 0: {
                    fw.write("string");
                    if (tf.def == null) break;
                    this.space(fw);
                    this.quoted(fw, tf.def);
                    break;
                }
                case 3: {
                    fw.write("date");
                    if (tf.def == null) break;
                    this.space(fw);
                    fw.write(tf.def);
                    break;
                }
                case 4: {
                    fw.write("time");
                    if (tf.def == null) break;
                    this.space(fw);
                    fw.write(tf.def);
                    break;
                }
                default: {
                    fw.write("unknownfield");
                    this.space(fw);
                    fw.write(tf.name);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.views.size()) {
            this.newline(fw);
            View view = (View)this.views.get(i);
            fw.write("view");
            this.space(fw);
            this.quoted(fw, view.name);
            int f = 0;
            while (f < view.fields.size()) {
                ViewField vf = (ViewField)view.fields.get(f);
                this.space(fw);
                this.quoted(fw, vf.name);
                this.space(fw);
                fw.write(String.valueOf(vf.width));
                ++f;
            }
            ++i;
        }
        this.option(fw, "backup", this.backup);
        this.option(fw, "copy-prevention", this.copyPrevention);
        this.option(fw, "find", this.globalFind);
        this.option(fw, "read-only", this.readOnly);
        this.option(fw, "systemPWD", this.protectedDb);
        this.newline(fw);
        fw.write("creator");
        this.space(fw);
        fw.write(this.creatorId);
        this.newline(fw);
        if (this.dateFormat != null) {
            this.newline(fw);
            fw.write("format");
            this.space(fw);
            fw.write("date");
            this.space(fw);
            fw.write(this.dateFormat);
        }
        if (this.timeFormat != null) {
            this.newline(fw);
            fw.write("format");
            this.space(fw);
            fw.write("time");
            this.space(fw);
            fw.write(this.timeFormat);
        }
        this.newline(fw);
        fw.write("extended");
        this.space(fw);
        if (this.extendedCsvFormat) {
            fw.write("on");
        } else {
            fw.write("off");
        }
        this.newline(fw);
        fw.write("separator");
        this.space(fw);
        fw.write(this.separator);
        if (this.csvPath != null) {
            this.newline(fw);
            fw.write("csvfile");
            this.space(fw);
            this.quoted(fw, this.csvPath);
        }
        this.newline(fw);
    }

    public void read(BufferedReader reader) throws IOException {
        this.views.clear();
        this.csvPath = null;
        this.backup = false;
        this.copyPrevention = false;
        this.databasePath = null;
        this.databaseTitle = null;
        this.extendedCsvFormat = true;
        this.globalFind = false;
        this.protectedDb = false;
        this.readOnly = false;
        this.separator = (char)44;
        this.tableFields.clear();
        this.timeFormat = "%H:%M";
        this.dateFormat = "%Y/%m/%d";
        String s = null;
        while ((s = reader.readLine()) != null) {
            String[] tokens = StringUtils.breakStringApart(s, ' ');
            if (tokens.length == 0) continue;
            String directive = tokens[0];
            if (directive.equals("title")) {
                if (tokens.length < 2) {
                    throw new IOException("Invalid File Format, title directive format is title <title>");
                }
                this.databaseTitle = tokens[1];
                continue;
            }
            if (directive.equals("field")) {
                this.handleFieldDirective(tokens);
                continue;
            }
            if (directive.equals("view")) {
                this.handleViewDirective(tokens);
                continue;
            }
            if (directive.equals("option")) {
                this.handleOptionDirective(tokens);
                continue;
            }
            if (directive.equals("extended")) {
                this.extendedCsvFormat = this.valueOfSetting(tokens[1]);
                continue;
            }
            if (directive.equals("separator")) {
                this.separator = tokens[1].charAt(0);
                continue;
            }
            if (directive.equals("csvfile")) {
                this.csvPath = tokens[1];
                continue;
            }
            if (directive.equals("format")) {
                this.handleFormatDirective(tokens);
                continue;
            }
            if (!directive.equals("creator")) continue;
            this.handleCreatorDirective(tokens);
        }
    }

    private void handleCreatorDirective(String[] tokens) throws IOException {
        if (tokens.length < 2) {
            throw new IOException("Invalid creator directive, must be creator {creatorid}");
        }
        String creatorId = tokens[1];
        this.setCreatorId(creatorId);
    }

    private void handleFormatDirective(String[] tokens) throws IOException {
        if (tokens.length < 3) {
            throw new IOException("Invalid File Format, format directive format is 'format (date|time) <format>'");
        }
        String pattern = tokens[2];
        if (tokens[1].equals("date")) {
            this.dateFormat = pattern;
        } else if (tokens[1].equals("time")) {
            this.timeFormat = pattern;
        } else {
            throw new IOException("Invalid format type : " + tokens[1]);
        }
    }

    private void handleFieldDirective(String[] tokens) throws IOException {
        if (tokens.length < 3) {
            throw new IOException("Invalid File Format, field directive format is field <name> <type> <size> <default>");
        }
        TableField field = new TableField();
        field.name = tokens[1];
        String type = tokens[2];
        if (type.equals("integer")) {
            field.type = 2;
        } else if (type.equals("float")) {
            field.type = 8;
        } else if (type.equals("string")) {
            field.type = 0;
        } else if (type.equals("date")) {
            field.type = 3;
        } else if (type.equals("time")) {
            field.type = 4;
        } else if (type.equals("boolean")) {
            field.type = 1;
        } else {
            throw new IOException("invalid field type:" + type);
        }
        String def = null;
        if (tokens.length == 4) {
            def = tokens[3];
        }
        if (def != null) {
            field.def = def;
        }
        this.tableFields.add(field);
    }

    private void handleViewDirective(String[] tokens) throws IOException {
        if (tokens.length < 4) {
            throw new IOException("Invalid File Format, view directive format is view <name> (<fieldname> <size>)*");
        }
        View view = new View();
        view.name = tokens[1];
        int i = 2;
        while (i < tokens.length) {
            ViewField vf = new ViewField();
            vf.name = tokens[i];
            vf.width = Integer.parseInt(tokens[i + 1]);
            view.fields.add(vf);
            i += 2;
        }
        this.views.add(view);
    }

    private void handleOptionDirective(String[] tokens) throws IOException {
        if (tokens.length < 3) {
            throw new IOException("Invalid file format, option directive is 'option <option-name> <on|off>'");
        }
        String subdirect = tokens[1];
        boolean setting = this.valueOfSetting(tokens[2]);
        if (subdirect.equals("backup")) {
            this.backup = setting;
        } else if (subdirect.equals("copy-prevention")) {
            this.copyPrevention = setting;
        } else if (subdirect.equals("find")) {
            this.globalFind = setting;
        } else if (subdirect.equals("read-only")) {
            this.readOnly = setting;
        } else if (subdirect.equals("systemPWD")) {
            this.protectedDb = setting;
        }
    }

    private boolean valueOfSetting(String setting) {
        return setting.equals("on");
    }

    public DateFormat getJavaDateFormat() {
        return new SimpleDateFormat(this.convertIfoFormatToSDFFormat(this.dateFormat));
    }

    public DateFormat getJavaTimeFormat() {
        return new SimpleDateFormat(this.convertIfoFormatToSDFFormat(this.timeFormat));
    }

    private String convertIfoFormatToSDFFormat(String in) {
        String[][] translation = new String[][]{{"%d", "dd"}, {"%m", "MM"}, {"%y", "yy"}, {"%Y", "yyyy"}, {"%H", "HH"}, {"%M", "mm"}};
        int i = 0;
        while (i < translation.length) {
            String from = translation[i][0];
            String to = translation[i][1];
            in = this.replace(in, from, to);
            ++i;
        }
        return in;
    }

    private String replace(String in, String replace, String replaceWith) {
        int idx = -1;
        while ((idx = in.indexOf(replace)) > -1) {
            in = String.valueOf(in.substring(0, idx)) + replaceWith + in.substring(idx + replace.length(), in.length());
        }
        return in;
    }

    public static void main(String[] in) {
        System.out.println(CSVImportModel.sample());
    }

    public boolean isBackup() {
        return this.backup;
    }

    public boolean isCopyPrevention() {
        return this.copyPrevention;
    }

    public String getCsvPath() {
        return this.csvPath;
    }

    public String getDatabasePath() {
        return this.databasePath;
    }

    public String getDatabaseTitle() {
        return this.databaseTitle;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public boolean isExtendedCsvFormat() {
        return this.extendedCsvFormat;
    }

    public boolean isGlobalFind() {
        return this.globalFind;
    }

    public boolean isProtectedDb() {
        return this.protectedDb;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public void setCopyPrevention(boolean copyPrevention) {
        this.copyPrevention = copyPrevention;
    }

    public void setCsvPath(String csvPath) {
        this.csvPath = csvPath;
    }

    public void setDatabasePath(String databasePath) {
        this.databasePath = databasePath;
    }

    public void setDatabaseTitle(String databaseTitle) {
        if (databaseTitle != null && databaseTitle.trim().length() == 0) {
            databaseTitle = null;
        }
        this.databaseTitle = databaseTitle;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setExtendedCsvFormat(boolean extendedCsvFormat) {
        this.extendedCsvFormat = extendedCsvFormat;
    }

    public void setGlobalFind(boolean globalFind) {
        this.globalFind = globalFind;
    }

    public void setProtectedDb(boolean protectedDb) {
        this.protectedDb = protectedDb;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public int getViewCount() {
        return this.views.size();
    }

    public int getFieldCount() {
        return this.tableFields.size();
    }

    public View getView(int i) {
        return (View)this.views.get(i);
    }

    public TableField getField(int i) {
        return (TableField)this.tableFields.get(i);
    }

    private void space(Writer fw) throws IOException {
        fw.write(" ");
    }

    private void quoted(Writer fw, String s) throws IOException {
        fw.write("\"");
        fw.write(s);
        fw.write("\"");
    }

    private void newline(Writer fw) throws IOException {
        fw.write("\n");
    }

    private void option(Writer fw, String name, boolean setting) throws IOException {
        this.newline(fw);
        fw.write(name);
        this.space(fw);
        if (setting) {
            fw.write("on");
        } else {
            fw.write("off");
        }
    }

    public static CSVImportModel sample() {
        CSVImportModel sample = new CSVImportModel();
        TableField tf1 = new TableField();
        tf1.name = "Id Number";
        tf1.type = 2;
        TableField tf2 = new TableField();
        tf2.name = "Name";
        tf2.type = 0;
        tf2.def = "no name";
        sample.tableFields.add(tf1);
        sample.tableFields.add(tf2);
        View view = new View();
        view.name = "Just Names";
        ViewField vf = new ViewField();
        vf.name = tf2.name;
        vf.width = 150;
        view.fields.add(vf);
        sample.views.add(view);
        view = new View();
        view.name = "Small View";
        vf = new ViewField();
        vf.name = tf1.name;
        vf.width = 15;
        view.fields.add(vf);
        vf = new ViewField();
        vf.name = tf2.name;
        vf.width = 15;
        view.fields.add(vf);
        sample.views.add(view);
        sample.databaseTitle = "Sample Database";
        return sample;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.write(sw);
        }
        catch (Exception e) {
            return e.toString();
        }
        return sw.toString();
    }

    public boolean isComplete() {
        boolean complete = true;
        if (this.databaseTitle == null || this.databaseTitle.length() == 0) {
            complete = false;
        }
        if (this.tableFields.size() == 0) {
            complete = false;
        }
        if (this.csvPath == null || this.csvPath.length() == 0) {
            complete = false;
        }
        if (this.databasePath == null || this.databasePath.length() == 0) {
            complete = false;
        }
        return complete;
    }

    public void addField(String string, int i, String def) {
        TableField tf = new TableField();
        tf.name = string;
        tf.type = i;
        tf.def = def;
        this.tableFields.add(tf);
    }

    public void removeField(int selectedRow) {
        this.tableFields.remove(selectedRow);
    }

    public View addView(String string) {
        View v = new View();
        v.name = string;
        this.views.add(v);
        return v;
    }

    public void removeView(int selectedRow) {
        this.views.remove(selectedRow);
    }

    public void setCreatorId(String string) {
        this.creatorId = string == null || string.length() < 4 ? "DBOS" : (string.length() > 4 ? string.substring(0, 4) : string);
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public static class TableField {
        public String name;
        public int type;
        public String def;
    }

    public static class View {
        public String name;
        public List fields = new LinkedList();

        public ViewField getViewField(int j) {
            return (ViewField)this.fields.get(j);
        }

        public ViewField getViewField(String fieldName) {
            int i = 0;
            while (i < this.fields.size()) {
                if (this.getViewField((int)i).name.equals(fieldName)) {
                    return this.getViewField(i);
                }
                ++i;
            }
            return null;
        }
    }

    public static class ViewField {
        public String name;
        public int width;
    }
}

