/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools.simplecreator.filemp3;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.farng.mp3.MP3File;
import org.farng.mp3.TagConstant;
import palmdb.PalmDbException;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBField;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.tools.AbstractPlugin;

public class Plugin
extends AbstractPlugin {
    private String creator = "DBOS";
    private String databaseName = "Imported";
    private PilotDBDatabase db;
    private String databasePath = null;
    private File[] directories;
    private String fileFilter = "*.*";
    private boolean importFileName;
    private boolean importFileExt;
    private boolean importFileSize;
    private boolean importFileLastModified;
    private boolean importTitle;
    private boolean importArtist;
    private boolean importAlbum;
    private boolean importYear;
    private boolean importComment;
    private boolean importGenre;
    private boolean includeSubdirectories;
    private File pdbFile;

    public void configure(CommandLine config) {
        String filter = config.getOptionValue("f");
        this.setFileFilter(filter);
        String pdbPath = config.getOptionValue("o");
        if (pdbPath == null || pdbPath.equals("")) {
            pdbPath = "out.pdb";
        }
        this.setDatabasePath(pdbPath);
        String name = config.getOptionValue("n");
        this.databaseName = name == null ? "Imported-" + System.currentTimeMillis() : name;
        String cols = config.getOptionValue("c");
        if (cols == null || cols.length() == 0) {
            cols = "nxzm";
        }
        this.importFileName = cols.indexOf("n") > -1;
        this.importFileExt = cols.indexOf("x") > -1;
        this.importFileSize = cols.indexOf("z") > -1;
        this.importFileLastModified = cols.indexOf("m") > -1;
        this.importTitle = cols.indexOf("t") > -1;
        this.importArtist = cols.indexOf("r") > -1;
        this.importAlbum = cols.indexOf("l") > -1;
        this.importYear = cols.indexOf("y") > -1;
        this.importComment = cols.indexOf("c") > -1;
        this.importGenre = cols.indexOf("g") > -1;
        String recursive = config.getOptionValue("r");
        this.includeSubdirectories = new Boolean(recursive);
        String[] dirs = config.getOptionValues("d");
        if (dirs == null || dirs.length == 0) {
            dirs = new String[]{"."};
        }
        File[] fs = new File[dirs.length];
        int i = 0;
        while (i < dirs.length) {
            File f = new File(dirs[i]);
            if (f.isDirectory() && f.canRead()) {
                fs[i] = f;
            } else {
                this.addError("Invalid Directory : {0}", new Object[]{f.getAbsolutePath()});
            }
            ++i;
        }
        this.setDirectories(fs);
    }

    private void createDirRecord(File file, PilotDBDatabase db) throws IOException, PalmDbException {
        PilotDBRecord record = db.createRecord();
        int currentColumn = 0;
        if (this.importFileName) {
            record.setString(currentColumn++, file.getName());
        }
        if (this.importFileExt) {
            record.setString(currentColumn++, "<dir>");
        }
        if (this.importFileSize) {
            ++currentColumn;
        }
        if (this.importFileLastModified) {
            record.setString(currentColumn++, new Date(file.lastModified()).toString());
        }
    }

    private void createRecord(File file, PilotDBDatabase db) throws IOException, PalmDbException {
        PilotDBRecord record = db.createRecord();
        int currentColumn = 0;
        if (this.importFileName) {
            if (file.getName().startsWith(".")) {
                record.setString(currentColumn++, file.getName());
            } else if (file.getName().indexOf(".") == -1) {
                record.setString(currentColumn++, file.getName());
            } else {
                record.setString(currentColumn++, file.getName().substring(0, file.getName().lastIndexOf(".")));
            }
        }
        if (this.importFileExt) {
            if (file.getName().startsWith(".")) {
                record.setString(currentColumn++, null);
            } else if (file.getName().indexOf(".") == -1) {
                record.setString(currentColumn++, null);
            } else {
                record.setString(currentColumn++, file.getName().substring(file.getName().lastIndexOf(".") + 1, file.getName().length()));
            }
        }
        if (this.importFileSize) {
            record.setInteger(currentColumn++, (int)file.length());
        }
        if (this.importFileLastModified) {
            record.setString(currentColumn++, new Date(file.lastModified()).toString());
        }
        if (this.importTitle || this.importArtist || this.importAlbum || this.importYear || this.importGenre || this.importComment) {
            try {
                MP3File mp3 = new MP3File(file);
                if (mp3.hasID3v1Tag()) {
                    if (this.importTitle) {
                        record.setString(currentColumn++, mp3.getID3v1Tag().getTitle());
                    }
                    if (this.importArtist) {
                        record.setString(currentColumn++, mp3.getID3v1Tag().getArtist());
                    }
                    if (this.importAlbum) {
                        record.setString(currentColumn++, mp3.getID3v1Tag().getAlbum());
                    }
                    String year = mp3.getID3v1Tag().getYear();
                    if (this.importYear) {
                        if (year != null & !year.equals("")) {
                            record.setString(currentColumn++, year);
                        } else {
                            ++currentColumn;
                        }
                    }
                    byte genreKey = mp3.getID3v1Tag().getGenre();
                    String genre = (String)TagConstant.genreIdToString.get(String.valueOf(genreKey));
                    if (this.importGenre) {
                        if (genre != null && !genre.equals("")) {
                            record.setString(currentColumn++, genre);
                        } else {
                            ++currentColumn;
                        }
                    }
                    if (this.importComment) {
                        record.setNote(currentColumn++, mp3.getID3v1Tag().getComment());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void execute() throws Exception {
        this.start();
        try {
            this.makeDb();
            this.setMessage("Created DB File : " + this.getPdbFile().getAbsolutePath());
        }
        catch (Exception e) {
            this.done();
            e.printStackTrace();
            throw e;
        }
        this.done();
    }

    public PilotDBDatabase getDb() {
        return this.db;
    }

    public Options getOptions() {
        Options opts = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("filter");
        OptionBuilder.withDescription("the file filter to use (*.mp3)");
        OptionBuilder.withLongOpt("file-filter");
        Option fOption = OptionBuilder.create("f");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("filename");
        OptionBuilder.withDescription("the pdb output file");
        OptionBuilder.withLongOpt("output-file");
        Option oOption = OptionBuilder.create("o");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("title");
        OptionBuilder.withDescription("the database title");
        OptionBuilder.withLongOpt("title");
        Option nOption = OptionBuilder.create("n");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("columns");
        OptionBuilder.withDescription("the database columns to create");
        OptionBuilder.withLongOpt("columns");
        Option cOption = OptionBuilder.create("c");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("recursive");
        OptionBuilder.withDescription("include subdirectories");
        OptionBuilder.withLongOpt("include-subs");
        Option rOption = OptionBuilder.create("r");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName("dirs");
        OptionBuilder.withDescription("directory names");
        OptionBuilder.withLongOpt("directories");
        Option dOption = OptionBuilder.create("d");
        opts.addOption(fOption);
        opts.addOption(oOption);
        opts.addOption(nOption);
        opts.addOption(rOption);
        opts.addOption(cOption);
        opts.addOption(dOption);
        return opts;
    }

    public File getPdbFile() {
        return this.pdbFile;
    }

    public boolean isReady() {
        return this.directories != null && this.getPdbFile() != null && !this.hasErrors();
    }

    private void makeDb() throws Exception {
        this.setMessage("making db");
        int columnCount = 0;
        columnCount += this.importFileName ? 1 : 0;
        columnCount += this.importFileExt ? 1 : 0;
        columnCount += this.importFileSize ? 1 : 0;
        columnCount += this.importFileLastModified ? 1 : 0;
        columnCount += this.importTitle ? 1 : 0;
        columnCount += this.importArtist ? 1 : 0;
        columnCount += this.importAlbum ? 1 : 0;
        columnCount += this.importYear ? 1 : 0;
        columnCount += this.importGenre ? 1 : 0;
        String[] cols = new String[columnCount += this.importComment ? 1 : 0];
        int currentColumn = 0;
        if (this.importFileName) {
            cols[currentColumn++] = "Name";
        }
        if (this.importFileExt) {
            cols[currentColumn++] = "Ext";
        }
        if (this.importFileSize) {
            cols[currentColumn++] = "Size";
        }
        if (this.importFileLastModified) {
            cols[currentColumn++] = "Last Modified";
        }
        if (this.importTitle) {
            cols[currentColumn++] = "Title";
        }
        if (this.importArtist) {
            cols[currentColumn++] = "Artist";
        }
        if (this.importAlbum) {
            cols[currentColumn++] = "Album";
        }
        if (this.importYear) {
            cols[currentColumn++] = "Year";
        }
        if (this.importGenre) {
            cols[currentColumn++] = "Genre";
        }
        if (this.importComment) {
            cols[currentColumn++] = "Comment";
        }
        short[] types = new short[columnCount];
        currentColumn = 0;
        if (this.importFileName) {
            types[currentColumn++] = 0;
        }
        if (this.importFileExt) {
            types[currentColumn++] = 0;
        }
        if (this.importFileSize) {
            types[currentColumn++] = 2;
        }
        if (this.importFileLastModified) {
            types[currentColumn++] = 0;
        }
        if (this.importTitle) {
            types[currentColumn++] = 0;
        }
        if (this.importArtist) {
            types[currentColumn++] = 0;
        }
        if (this.importAlbum) {
            types[currentColumn++] = 0;
        }
        if (this.importYear) {
            types[currentColumn++] = 0;
        }
        if (this.importGenre) {
            types[currentColumn++] = 0;
        }
        if (this.importComment) {
            types[currentColumn++] = 5;
        }
        PilotDBSchema schema = new PilotDBSchema();
        int i = 0;
        while (i < cols.length) {
            schema.addField(new PilotDBField(types[i], cols[i]));
            ++i;
        }
        this.db = new PilotDBDatabase(this.databaseName, "DB00", this.creator, schema);
        this.db.setTitle(this.databaseName);
        this.readDirectories(this.db);
        FileOutputStream fos = new FileOutputStream(this.getPdbFile());
        this.db.write(fos);
        fos.flush();
        fos.close();
    }

    private void readDirectories(PilotDBDatabase db) throws IOException, PalmDbException {
        int i = 0;
        while (this.directories != null && i < this.directories.length) {
            File dir = this.directories[i];
            this.readDirectory(dir, db);
            ++i;
        }
    }

    private void readDirectory(File dir, PilotDBDatabase db) throws IOException, PalmDbException {
        File[] f = dir.listFiles();
        int steps = f.length;
        int i = 0;
        while (i < f.length) {
            File file = f[i];
            if (file.isDirectory()) {
                if (file.getName().matches(this.fileFilter)) {
                    this.createDirRecord(file, db);
                }
                this.readDirectory(f[i], db);
            } else {
                this.setSteps(steps);
                this.setStep(i + 1);
                this.setMessage(file.getName());
                if (file.getName().matches(this.fileFilter)) {
                    this.createRecord(file, db);
                }
            }
            ++i;
        }
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setDirectories(File[] directories) {
        this.directories = directories;
    }

    public void setFileFilter(String fileFilter) {
        if (fileFilter == null || fileFilter.equals("")) {
            fileFilter = "*";
        }
        this.fileFilter = fileFilter;
        this.fileFilter = this.fileFilter.replaceAll("\\.", "\\\\.");
        this.fileFilter = this.fileFilter.replaceAll("\\*", "\\.\\+");
    }

    public void setImportAlbum(boolean importAlbum) {
        this.importAlbum = importAlbum;
    }

    public void setImportArtist(boolean importArtist) {
        this.importArtist = importArtist;
    }

    public void setImportComment(boolean importComment) {
        this.importComment = importComment;
    }

    public void setImportFileExt(boolean importFileExt) {
        this.importFileExt = importFileExt;
    }

    public void setImportFileLastModified(boolean importFileLastModified) {
        this.importFileLastModified = importFileLastModified;
    }

    public void setImportFileName(boolean importFileName) {
        this.importFileName = importFileName;
    }

    public void setImportFileSize(boolean importFileSize) {
        this.importFileSize = importFileSize;
    }

    public void setImportGenre(boolean importGenre) {
        this.importGenre = importGenre;
    }

    public void setImportTitle(boolean importTitle) {
        this.importTitle = importTitle;
    }

    public void setImportYear(boolean importYear) {
        this.importYear = importYear;
    }

    public void setIncludeSubdirectories(boolean includeSubdirectories) {
        this.includeSubdirectories = includeSubdirectories;
    }

    public void setPdbFile(File pdbFile) {
        if (pdbFile.exists() && !pdbFile.canWrite()) {
            this.addError("{0} exists but is not writable", new Object[]{pdbFile.getAbsolutePath()});
        }
        this.pdbFile = pdbFile;
    }

    public String getDatabasePath() {
        return this.databasePath;
    }

    public void setDatabasePath(String databasePath) {
        this.databasePath = databasePath;
        File f = new File(databasePath);
        this.setPdbFile(f);
    }
}

