/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools.simplecreator.htmltable;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.xml.sax.SAXException;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBField;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.tools.AbstractPlugin;

public class Plugin
extends AbstractPlugin {
    private String tableSourceHref;
    private int tableNumber = 0;
    private boolean hasTableHeaderRow = false;
    private String pdbPath;
    private URL tableSourceUrl;
    private File pdbFile;
    private String title = "Imported";
    private String creator = "DBOS";
    StringBuffer curString;
    int currentTableNumber = -1;
    Vector headers;
    boolean intr;
    boolean intd;
    boolean intable;
    boolean inth;
    final byte IN_TAG = (byte)8;
    final byte TAG_START = 0;
    final byte TAG_NAME = 1;
    final byte TAG_ATTR_NAME = (byte)2;
    final byte TAG_ATTR_EQ = (byte)3;
    final byte TAG_ATTR_VALUE = (byte)4;
    final byte TAG_CHAR = (byte)5;
    final byte TAG_END = (byte)6;
    final byte IN_DELIM_STRING = (byte)7;
    final byte CLOSING_TAG_NAME = (byte)9;
    final byte CLOSING_TAG_START = (byte)10;
    byte parseState = (byte)-1;
    String parseTagName = null;
    String buf = null;
    String content = null;
    Vector rows = new Vector();
    Vector curRow;

    public Options getOptions() {
        Options opts = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("index");
        OptionBuilder.withDescription("the index of the table");
        OptionBuilder.withLongOpt("table-index");
        Option tOption = OptionBuilder.create("x");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("url");
        OptionBuilder.withDescription("the url of the html");
        OptionBuilder.withLongOpt("url");
        OptionBuilder.isRequired();
        Option uOption = OptionBuilder.create("u");
        OptionBuilder.withDescription("the table has a header row");
        OptionBuilder.withLongOpt("headers");
        Option hOption = OptionBuilder.create("d");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("filename");
        OptionBuilder.withDescription("the pdb output file");
        OptionBuilder.withLongOpt("output-file");
        OptionBuilder.isRequired();
        Option oOption = OptionBuilder.create("o");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("title");
        OptionBuilder.withDescription("the database title");
        OptionBuilder.withLongOpt("title");
        OptionBuilder.isRequired();
        Option nOption = OptionBuilder.create("n");
        OptionBuilder.withDescription("the creator id to use - default (DBOS)");
        OptionBuilder.withLongOpt("creator-id");
        Option creatorOption = OptionBuilder.create("c");
        opts.addOption(tOption);
        opts.addOption(uOption);
        opts.addOption(hOption);
        opts.addOption(oOption);
        opts.addOption(nOption);
        opts.addOption(creatorOption);
        return opts;
    }

    public boolean isReady() {
        return this.getTableSourceUrl() != null && this.getPdbFile() != null && !this.hasErrors();
    }

    public void configure(CommandLine config) {
        try {
            this.setTableNumber(Integer.parseInt(config.getOptionValue("t")));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
        try {
            this.setTableSourceHref(config.getOptionValue("u"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
        this.setHasTableHeaderRow(config.hasOption("h"));
        try {
            this.setPdbPath(config.getOptionValue("o"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
        try {
            this.setTitle(config.getOptionValue("n"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String cid = config.getOptionValue('c');
            if (cid != null) {
                this.creator = cid;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void execute() throws Exception {
        this.start();
        try {
            URLConnection conn = this.getTableSourceUrl().openConnection();
            int len = conn.getContentLength();
            this.setSteps(len + 20);
            int step = 0;
            InputStream is = conn.getInputStream();
            InputStreamReader r = new InputStreamReader(is);
            int ch = -1;
            block8: while ((ch = ((Reader)r).read()) != -1) {
                if (step++ % 100 == 0) {
                    this.setStep(step, String.valueOf(step) + " bytes read");
                }
                switch (ch) {
                    case 60: {
                        if (this.buf != null) {
                            this.characters(this.buf.toCharArray(), 0, this.buf.length());
                            this.buf = null;
                            this.parseState = this.TAG_START;
                            break;
                        }
                        this.parseState = this.TAG_START;
                        break;
                    }
                    case 47: {
                        if (this.parseState == 0) {
                            this.parseState = (byte)10;
                            break;
                        }
                        if (this.parseState != 1) continue block8;
                        this.parseTagName = this.buf;
                        this.buf = null;
                        break;
                    }
                    case 62: {
                        if (this.parseState == 1) {
                            this.parseTagName = this.buf;
                            this.buf = null;
                            this.startElement(this.parseTagName);
                        } else if (this.parseState == 8) {
                            this.startElement(this.parseTagName);
                            this.buf = null;
                        } else if (this.parseState == 9) {
                            this.parseTagName = this.buf;
                            this.endElement(this.parseTagName);
                            this.buf = null;
                        }
                        this.parseState = (byte)this.TAG_END;
                        break;
                    }
                    case 32: {
                        if (this.parseState == 1) {
                            this.parseTagName = this.buf;
                            this.buf = null;
                            this.parseState = (byte)8;
                            break;
                        }
                        if (this.parseState == 9) {
                            this.parseTagName = this.buf;
                            this.buf = null;
                            this.parseState = (byte)8;
                            break;
                        }
                        if (this.buf == null) {
                            this.buf = String.valueOf((char)ch);
                            break;
                        }
                        this.buf = String.valueOf(this.buf) + (char)ch;
                        break;
                    }
                    default: {
                        if (this.parseState == 0) {
                            this.parseState = 1;
                            this.buf = String.valueOf((char)ch);
                            break;
                        }
                        if (this.parseState == 10) {
                            this.parseState = (byte)9;
                            this.buf = String.valueOf((char)ch);
                            break;
                        }
                        this.buf = this.parseState == 1 || this.parseState == 9 ? String.valueOf(this.buf) + (char)ch : (this.buf == null ? String.valueOf((char)ch) : String.valueOf(this.buf) + (char)ch);
                    }
                }
            }
            this.setMessage("parsed html");
            this.makeDb();
            this.setMessage("Created DB File : " + this.getPdbPath());
        }
        catch (Exception e) {
            this.done();
            e.printStackTrace();
            throw e;
        }
        this.done();
    }

    private void makeDb() throws Exception {
        this.setMessage("making db");
        int columnCount = ((Vector)this.rows.get(0)).size();
        Object[] cols = new String[columnCount];
        int i = 0;
        while (i < cols.length) {
            cols[i] = "Column " + i;
            ++i;
        }
        if (this.hasTableHeaderRow()) {
            this.headers.copyInto(cols);
        }
        PilotDBSchema schema = new PilotDBSchema();
        int i2 = 0;
        while (i2 < cols.length) {
            schema.addField(new PilotDBField(0, (String)cols[i2]));
            ++i2;
        }
        PilotDBDatabase db = new PilotDBDatabase(this.title, "DB00", this.creator, schema);
        this.setSteps(this.rows.size());
        int row = 0;
        while (row < this.rows.size()) {
            this.setStep(row, String.valueOf(row + 1) + " records created");
            Vector rec = (Vector)this.rows.get(row);
            PilotDBRecord record = db.createRecord();
            int col = 0;
            while (col < cols.length) {
                String value = rec.get(col).toString();
                record.setString(col, value);
                ++col;
            }
            ++row;
        }
        FileOutputStream fos = new FileOutputStream(this.getPdbFile());
        db.write(fos);
        fos.flush();
        fos.close();
    }

    public void characters(char[] parm1, int parm2, int parm3) throws SAXException {
        if (this.intd) {
            if (this.curString == null) {
                this.curString = new StringBuffer();
            }
            this.curString.append(parm1, parm2, parm3);
        }
    }

    public void startElement(String localname) {
        if (localname.equalsIgnoreCase("table")) {
            ++this.currentTableNumber;
            if (this.currentTableNumber == this.tableNumber) {
                this.intable = true;
            }
        } else if (localname.equalsIgnoreCase("tr") && this.intable) {
            this.curRow = new Vector();
            this.intr = true;
        } else if (localname.equalsIgnoreCase("td") && this.intr) {
            this.intd = true;
        } else if (localname.equalsIgnoreCase("th") && this.intr) {
            this.intd = true;
        }
    }

    public void endElement(String localname) {
        if (localname == null) {
            return;
        }
        if (localname.equalsIgnoreCase("table") && this.intable) {
            this.intable = false;
        } else if (localname.equalsIgnoreCase("tr") && this.intr) {
            int len = 0;
            int i = 0;
            while (i < this.curRow.size()) {
                len += this.curRow.get(i).toString().trim().length();
                ++i;
            }
            if (this.hasTableHeaderRow() && len > 0 && this.rows.size() == 0 && this.headers == null) {
                this.headers = this.curRow;
            } else if (len > 0) {
                this.rows.add(this.curRow);
            }
            this.intr = false;
            this.inth = false;
            this.intd = false;
            this.curRow = null;
        } else if (localname.equalsIgnoreCase("td") && this.intd) {
            this.intd = false;
            if (this.curString != null) {
                this.curRow.add(this.curString.toString().trim());
            } else {
                this.curRow.add("");
            }
            this.curString = null;
        } else if (localname.equalsIgnoreCase("th") && this.intd) {
            this.setHasTableHeaderRow(true);
            this.intd = false;
            if (this.curString != null) {
                this.curRow.add(this.curString.toString().trim());
            } else {
                this.curRow.add("");
            }
            this.curString = null;
        }
    }

    public int getTableNumber() {
        return this.tableNumber;
    }

    public void setTableNumber(int tableNumber) {
        if (tableNumber < 0) {
            this.addError("table number must be greater than 0", new Object[0]);
        }
        this.tableNumber = tableNumber;
    }

    public String getTableSourceHref() {
        return this.tableSourceHref;
    }

    public URL getTableSourceUrl() {
        return this.tableSourceUrl;
    }

    public void setTableSourceHref(String tableSourceHref) {
        this.tableSourceHref = tableSourceHref;
        try {
            this.tableSourceUrl = new URL(tableSourceHref);
        }
        catch (MalformedURLException mue) {
            this.addError("Invalid HREF {0}", new Object[]{tableSourceHref});
        }
    }

    public void setTableSourceUrl(URL tableSourceUrl) {
        if (tableSourceUrl == null) {
            this.addError("tableSourceUrl cannot be null", new Object[0]);
        } else {
            this.tableSourceUrl = tableSourceUrl;
            this.tableSourceHref = tableSourceUrl.toExternalForm();
        }
    }

    public boolean hasTableHeaderRow() {
        return this.hasTableHeaderRow;
    }

    public void setHasTableHeaderRow(boolean hasTableHeaderRow) {
        this.hasTableHeaderRow = hasTableHeaderRow;
    }

    public String getPdbPath() {
        return this.pdbPath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setPdbPath(String pdbPath) {
        this.pdbPath = pdbPath;
        if (pdbPath == null) {
            this.addError("pdb path cannot be null", new Object[0]);
            return;
        }
        File f = new File(pdbPath);
        if (f.exists() && !f.canWrite()) {
            this.addError("{0} exists and is not writable", new Object[]{pdbPath});
            return;
        }
        this.pdbFile = f;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "no title";
        }
        this.title = title;
    }

    public File getPdbFile() {
        return this.pdbFile;
    }

    public void setPdbFile(File pdbFile) {
        if (pdbFile.exists() && !pdbFile.canWrite()) {
            this.addError("{0} exists but is not writable", new Object[]{pdbFile.getAbsolutePath()});
        }
        this.pdbFile = pdbFile;
        this.pdbPath = pdbFile.getAbsolutePath();
    }
}

