/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import pilotdb.ui.Application;
import pilotdb.ui.Messages;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.CommandHandler;
import pilotdb.ui.databaselist.DatabaseList;
import pilotdb.ui.images.Images;
import pilotdb.ui.recordsetview.DynamicForm;
import pilotdb.ui.recordsetview.RecordsetList;
import pilotdb.ui.util.FlatJButton;

public class MainToolBar
extends JToolBar
implements CommandHandler,
ActionListener {
    Application application;
    JButton jmDatabaseDelete = new FlatJButton();
    JButton jmiNewDatabase = new FlatJButton();
    JButton jmiNewView = new FlatJButton();
    JButton jmiOpenDirectory = new FlatJButton();
    JButton jmiCommittAll = new FlatJButton();
    JButton jbNewDatabase = new FlatJButton();
    JButton jmiCommitDatabase = new FlatJButton();
    JButton jmiDatabaseEditSchema = new FlatJButton();
    JButton jmiDbProps = new FlatJButton();
    JButton jmiInstallDatabase = new FlatJButton();
    JButton jmiRecordNew = new FlatJButton();
    JButton jmiRecordCopy = new FlatJButton();
    JButton jmiRecordDelete = new FlatJButton();
    JButton jmiRecordEdit = new FlatJButton();
    JButton jmiRecordSave = new FlatJButton();
    JButton jmiRecordUndo = new FlatJButton();
    JButton jmiSortDatabase = new FlatJButton();
    JButton jmiViewResizeColumns = new FlatJButton();
    JButton jmiViewPrefs = new FlatJButton();
    CommandHandler successor = null;

    public MainToolBar() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.application == null) {
            return;
        }
        Command ce = null;
        ce = new Command(this, e.getActionCommand(), null);
        this.application.postEvent(ce);
    }

    public void addToChain(CommandHandler handler) {
        if (this.successor != null) {
            this.successor.addToChain(handler);
        } else {
            this.successor = handler;
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public CommandHandler getSuccessor() {
        return this.successor;
    }

    public void handle(Command evt) {
        if (evt.equals("msg-windowstate-changed")) {
            this.windowStateChanged(this.getApplication().getMainWindow().getDesktop().getSelectedFrame());
        }
        if (this.successor != null) {
            this.successor.handle(evt);
        }
    }

    private void windowStateChanged(JInternalFrame jif) {
        if (jif instanceof DynamicForm) {
            DynamicForm df = (DynamicForm)jif;
            this.jmDatabaseDelete.setEnabled(false);
            this.jmiNewDatabase.setEnabled(false);
            this.jmiNewView.setEnabled(false);
            this.jmiOpenDirectory.setEnabled(false);
            this.jmiCommittAll.setEnabled(false);
            this.jbNewDatabase.setEnabled(false);
            this.jmiCommitDatabase.setEnabled(false);
            this.jmiDatabaseEditSchema.setEnabled(false);
            this.jmiDbProps.setEnabled(false);
            this.jmiInstallDatabase.setEnabled(false);
            this.jmiRecordNew.setEnabled(!df.isEditing());
            this.jmiRecordCopy.setEnabled(!df.isEditing());
            this.jmiRecordDelete.setEnabled(!df.isEditing());
            this.jmiRecordEdit.setEnabled(!df.isEditing());
            this.jmiRecordSave.setEnabled(df.isEditing());
            this.jmiRecordUndo.setEnabled(df.isEditing());
            this.jmiSortDatabase.setEnabled(false);
            this.jmiViewPrefs.setEnabled(true);
            this.jmiViewResizeColumns.setEnabled(false);
        } else if (jif instanceof RecordsetList) {
            RecordsetList rl = (RecordsetList)jif;
            this.jmDatabaseDelete.setEnabled(false);
            this.jmiNewDatabase.setEnabled(false);
            this.jmiNewView.setEnabled(false);
            this.jmiOpenDirectory.setEnabled(false);
            this.jmiCommittAll.setEnabled(false);
            this.jbNewDatabase.setEnabled(false);
            this.jmiCommitDatabase.setEnabled(false);
            this.jmiDatabaseEditSchema.setEnabled(false);
            this.jmiDbProps.setEnabled(false);
            this.jmiInstallDatabase.setEnabled(false);
            this.jmiRecordNew.setEnabled(true);
            this.jmiRecordCopy.setEnabled(rl.getSelectedRecord() != null);
            this.jmiRecordDelete.setEnabled(rl.getSelectedRecord() != null);
            this.jmiRecordEdit.setEnabled(rl.getSelectedRecord() != null);
            this.jmiRecordSave.setEnabled(false);
            this.jmiRecordUndo.setEnabled(false);
            this.jmiSortDatabase.setEnabled(false);
            this.jmiViewPrefs.setEnabled(true);
            this.jmiViewResizeColumns.setEnabled(true);
        } else if (jif instanceof DatabaseList) {
            DatabaseList dl = (DatabaseList)jif;
            this.jmDatabaseDelete.setEnabled(dl.getSelectedDatabases().length > 0);
            this.jmiNewDatabase.setEnabled(true);
            this.jmiNewView.setEnabled(dl.getSelectedDatabases().length == 0);
            this.jmiOpenDirectory.setEnabled(true);
            this.jmiCommittAll.setEnabled(true);
            this.jbNewDatabase.setEnabled(true);
            this.jmiCommitDatabase.setEnabled(dl.getSelectedDatabases().length > 0);
            this.jmiDatabaseEditSchema.setEnabled(dl.getSelectedDatabases().length == 1);
            this.jmiDbProps.setEnabled(dl.getSelectedDatabases().length == 1);
            this.jmiInstallDatabase.setEnabled(dl.getSelectedDatabases().length > 0);
            this.jmiRecordNew.setEnabled(true);
            this.jmiRecordCopy.setEnabled(false);
            this.jmiRecordDelete.setEnabled(false);
            this.jmiRecordEdit.setEnabled(false);
            this.jmiRecordSave.setEnabled(false);
            this.jmiRecordUndo.setEnabled(false);
            this.jmiSortDatabase.setEnabled(false);
            this.jmiViewPrefs.setEnabled(true);
            this.jmiViewResizeColumns.setEnabled(true);
        }
    }

    private void initListeners() {
        Component[] cs = this.getComponents();
        int i = 0;
        while (i < cs.length) {
            if (cs[i] instanceof JButton) {
                JButton jmi = (JButton)cs[i];
                jmi.addActionListener(this);
            }
            ++i;
        }
    }

    public boolean isTail() {
        return this.successor == null;
    }

    private void jbInit() throws Exception {
        this.jmiInstallDatabase.setText(Messages.getString("MainToolBar.InstallDatabase"));
        this.jmiInstallDatabase.setActionCommand("mnu-install-database");
        this.jmiInstallDatabase.setEnabled(false);
        this.jmiOpenDirectory.setActionCommand("mnu-open-directory");
        this.jmiOpenDirectory.setIcon(Images.OPEN_ICON);
        this.jmiOpenDirectory.setToolTipText(Messages.getString("MainToolBar.OpenWorkingDirectory"));
        this.add(this.jmiOpenDirectory);
        this.jbNewDatabase.setActionCommand("mnu-show-tablemakergui");
        this.jbNewDatabase.setToolTipText(Messages.getString("MainToolBar.CreateNewDatabase"));
        this.jbNewDatabase.setIcon(Images.ADD_DATABASE_ICON);
        this.add(this.jbNewDatabase);
        this.jmiCommittAll.setActionCommand("mnu-commit-databases");
        this.jmiCommittAll.setToolTipText(Messages.getString("MainToolBar.SaveAll"));
        this.jmiCommittAll.setIcon(Images.COMMITDBS_ICON);
        this.add(this.jmiCommittAll);
        this.jmiCommitDatabase.setActionCommand("mnu-commit-database");
        this.jmiCommitDatabase.setToolTipText(Messages.getString("MainToolBar.CommitDatabase"));
        this.jmiCommitDatabase.setIcon(Images.COMMITDB_ICON);
        this.add(this.jmiCommitDatabase);
        this.jmDatabaseDelete.setActionCommand("mnu-delete-database");
        this.jmDatabaseDelete.setToolTipText(Messages.getString("MainToolBar.DeleteTheSelectedDatabase"));
        this.jmDatabaseDelete.setIcon(Images.DELETEDB_ICON);
        this.add(this.jmDatabaseDelete);
        this.add(new Box.Filler(new Dimension(25, 5), new Dimension(25, 5), new Dimension(25, 5)));
        this.jmiDbProps.setActionCommand("mnu-show-dbprops");
        this.jmiDbProps.setText(Messages.getString("MainToolBar.Properties"));
        this.jmiRecordNew.setActionCommand("mnu-add-record");
        this.jmiRecordNew.setToolTipText(Messages.getString("MainToolBar.NewRecord"));
        this.jmiRecordNew.setIcon(Images.ADD_RECORD_ICON);
        this.add(this.jmiRecordNew);
        this.jmiRecordCopy.setActionCommand("mnu-copy-record");
        this.jmiRecordCopy.setToolTipText(Messages.getString("MainToolBar.CopyRecord"));
        this.jmiRecordCopy.setIcon(Images.COPY_ICON);
        this.add(this.jmiRecordCopy);
        this.jmiRecordEdit.setActionCommand("mnu-edit-record");
        this.jmiRecordEdit.setToolTipText(Messages.getString("MainToolBar.EditRecord"));
        this.jmiRecordEdit.setIcon(Images.EDIT_ICON);
        this.add(this.jmiRecordEdit);
        this.jmiRecordDelete.setActionCommand("mnu-delete-record");
        this.jmiRecordDelete.setIcon(Images.DELETERECORD_ICON);
        this.jmiRecordDelete.setToolTipText(Messages.getString("MainToolBar.DeleteRecord"));
        this.add(this.jmiRecordDelete);
        this.jmiRecordSave.setActionCommand("mnu-save-record");
        this.jmiRecordSave.setToolTipText(Messages.getString("MainToolBar.SaveRecord"));
        this.jmiRecordSave.setIcon(Images.SAVE_RECORD_ICON);
        this.add(this.jmiRecordSave);
        this.jmiRecordUndo.setActionCommand("mnu-undo-record");
        this.jmiRecordUndo.setToolTipText(Messages.getString("MainToolBar.UndoChanges"));
        this.jmiRecordUndo.setIcon(Images.UNDO_ICON);
        this.add(this.jmiRecordUndo);
        this.jmiViewResizeColumns.setToolTipText(Messages.getString("MainToolBar.AutosizeColumns"));
        this.jmiViewResizeColumns.setIcon(Images.RESIZECOLUMNS_ICON);
        this.jmiViewResizeColumns.setActionCommand("mnu-autosizecolumns");
        this.add(this.jmiViewResizeColumns);
        this.add(new Box.Filler(new Dimension(25, 5), new Dimension(25, 5), new Dimension(25, 5)));
        this.jmiViewPrefs.setText(Messages.getString("MainToolBar.Preferences"));
        this.jmiViewPrefs.setActionCommand("mnu-show-preferences");
        this.add(this.jmiViewPrefs);
        JLabel spacer = new JLabel();
        spacer.setPreferredSize(new Dimension(100, 20));
        this.add(spacer);
        this.jmDatabaseDelete.setEnabled(false);
        this.jmiNewDatabase.setEnabled(false);
        this.jmiNewView.setEnabled(false);
        this.jmiOpenDirectory.setEnabled(true);
        this.jmiCommittAll.setEnabled(false);
        this.jbNewDatabase.setEnabled(false);
        this.jmiCommitDatabase.setEnabled(false);
        this.jmiDatabaseEditSchema.setEnabled(false);
        this.jmiDbProps.setEnabled(false);
        this.jmiInstallDatabase.setEnabled(false);
        this.jmiRecordNew.setEnabled(false);
        this.jmiRecordCopy.setEnabled(false);
        this.jmiRecordDelete.setEnabled(false);
        this.jmiRecordEdit.setEnabled(false);
        this.jmiRecordSave.setEnabled(false);
        this.jmiRecordUndo.setEnabled(false);
        this.jmiSortDatabase.setEnabled(false);
        this.jmiViewResizeColumns.setEnabled(false);
        this.jmiViewPrefs.setEnabled(true);
        this.initListeners();
    }

    public void setApplication(Application a) {
        this.application = a;
        a.addToChain(this);
    }

    public void setSuccessor(CommandHandler handler) {
        this.successor = handler;
    }
}

