/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JWindow;
import palmdb.VersionInfo;
import pilotdb.ui.Messages;

public class Splash
extends JWindow
implements WindowListener {
    VersionInfo version = VersionInfo.instance();
    String imagePath = Messages.getString("Splash.ImagePath");
    Image image = null;
    String text = Messages.getString("Splash.Loading");
    static /* synthetic */ Class class$0;

    public Splash() throws Exception {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("pilotdb.ui.images.Images");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.image = toolkit.getImage(clazz.getResource(this.imagePath));
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.image, 0);
        mediaTracker.waitForAll();
        int width = this.image.getWidth(this);
        int height = this.image.getHeight(this);
        this.setSize(width + 6, height + 6);
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDimension.width - (width + 6)) / 2, (screenDimension.height - (height + 6)) / 2);
        this.setVisible(true);
        this.requestFocus();
    }

    public void paint(Graphics g) {
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        g.setColor(Color.white);
        g.drawImage(this.image, 3, 3, this);
        if (this.text != null) {
            g.drawString(this.text, 5, this.getSize().height - 50);
        }
        String fullVersion = "Version " + this.version.getMajor() + "." + this.version.getMinor() + "." + this.version.getBuild();
        String date = "Built " + this.version.getBuildDate();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int fullVersionWidth = fm.stringWidth(fullVersion) + 10;
        g.drawString(fullVersion, this.getSize().width - fullVersionWidth, 3 + fm.getHeight());
        int dateWidth = this.getFontMetrics(this.getFont()).stringWidth(date) + 10;
        g.drawString(date, this.getSize().width - dateWidth, 3 + fm.getHeight() * 2);
    }

    public void setText(String string) {
        this.text = string;
        this.repaint(5, this.getSize().height - 30, 200, 30);
        this.paint(this.getGraphics());
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
        this.setCursor(Cursor.getDefaultCursor());
        this.dispose();
        arg0.getWindow().removeWindowListener(this);
    }
}

