/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import javax.swing.JInternalFrame;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.AbstractCommandHandler;
import pilotdb.ui.recordsetview.DynamicForm;
import pilotdb.ui.recordsetview.RecordsetList;

public class DynamicFormRecordCommandHandler
extends AbstractCommandHandler {
    public DynamicFormRecordCommandHandler(Application bridge) {
        super(bridge);
    }

    public void handle(Command command) {
        PilotDBRecord selectedRecord = null;
        if (command.equals("cmd-copy-record")) {
            try {
                DynamicForm df = (DynamicForm)this.getBridge().getMainWindow().getDesktop().getSelectedFrame();
                df.copy();
            }
            catch (ClassCastException cce) {
                try {
                    selectedRecord = this.getSelectedRecord();
                    Command c = new Command(this, "cmd-edit-record", selectedRecord);
                    this.getBridge().postEventAndWait(c);
                    DynamicForm df = (DynamicForm)this.getBridge().getMainWindow().getDesktop().getSelectedFrame();
                    df.copy();
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        } else if (command.equals("cmd-edit-record")) {
            try {
                DynamicForm df = (DynamicForm)this.getBridge().getMainWindow().getDesktop().getSelectedFrame();
                df.edit();
            }
            catch (ClassCastException cce) {
                selectedRecord = this.getSelectedRecord();
                Command c = new Command(this, "cmd-edit-record", selectedRecord);
                this.postEvent(c);
            }
        } else if (command.equals("cmd-delete-record")) {
            try {
                DynamicForm df = (DynamicForm)this.getBridge().getMainWindow().getDesktop().getSelectedFrame();
                df.delete();
            }
            catch (ClassCastException cce) {
                RecordsetList rl = (RecordsetList)this.getBridge().getMainWindow().getDesktop().getSelectedFrame();
                rl.delete();
            }
        } else if (command.equals("cmd-save-record")) {
            DynamicForm df = (DynamicForm)this.getBridge().getMainWindow().getDesktop().getSelectedFrame();
            df.save();
        } else if (command.equals("cmd-undo-record")) {
            DynamicForm df = (DynamicForm)this.getBridge().getMainWindow().getDesktop().getSelectedFrame();
            df.undo();
        }
        super.handle(command);
    }

    private void postEvent(Command c) {
        this.getBridge().postEvent(c);
    }

    private PilotDBRecord getSelectedRecord() {
        JInternalFrame jif = this.getBridge().getMainWindow().getDesktop().getSelectedFrame();
        if (jif instanceof RecordsetList) {
            RecordsetList rl = (RecordsetList)jif;
            return rl.getSelectedRecord();
        }
        if (jif instanceof DynamicForm) {
            DynamicForm dynamicForm = (DynamicForm)jif;
            return dynamicForm.getRecord();
        }
        throw new RuntimeException("RecordMenuHandler shouldn't handle anything when no form is active");
    }
}

