/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import pilotdb.PilotDBDatabase;
import pilotdb.tools.export.xls.Plugin;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.AbstractCommandHandler;
import pilotdb.ui.command.handler.CommandNames;
import pilotdb.ui.simplecreator.csv.WizardDialog;
import pilotdb.ui.simplecreator.filemp3.ImportFileMp3Dialog;
import pilotdb.ui.simplecreator.html.ImportHtmlDialog;
import pilotdb.ui.simplecreator.xml.ImportXmlDialog;

public class ExportDbToXmlHandler
extends AbstractCommandHandler {
    public ExportDbToXmlHandler(Application bridge) {
        super(bridge);
    }

    public void handle(final Command evt) {
        Runnable r = new Runnable(){

            public void run() {
                if (evt.equals("cmd-export-xml")) {
                    ExportDbToXmlHandler.this.doExportToXml();
                } else if (evt.equals("cmd-import-xml")) {
                    ExportDbToXmlHandler.this.doImportXml();
                } else if (evt.equals("cmd-import-html")) {
                    ExportDbToXmlHandler.this.doImportHtml();
                } else if (evt.equals("cmd-import-csv")) {
                    ExportDbToXmlHandler.this.doImportCsv();
                } else if (evt.equals(CommandNames.CMD_IMPORTMP3)) {
                    ExportDbToXmlHandler.this.doImportMp3();
                } else if (evt.equals("cmd-export-csv")) {
                    ExportDbToXmlHandler.this.doExportToCsv();
                } else if (evt.equals("cmd-export-rtf")) {
                    ExportDbToXmlHandler.this.doExportToRtf();
                } else if (evt.equals("cmd-export-pdf")) {
                    ExportDbToXmlHandler.this.doExportToPdf();
                } else if (evt.equals("cmd-export-xls")) {
                    ExportDbToXmlHandler.this.doExportToXls();
                } else if (evt.equals("cmd-export-html")) {
                    ExportDbToXmlHandler.this.doExportToHtml();
                }
            }
        };
        Thread t = new Thread(r);
        t.setPriority(5);
        t.start();
        super.handle(evt);
    }

    private void doImportCsv() {
        WizardDialog dialog = new WizardDialog(this.getBridge());
        dialog.setVisible(true);
    }

    private void doImportHtml() {
        ImportHtmlDialog dialog = new ImportHtmlDialog(this.getBridge());
        dialog.setVisible(true);
    }

    private void doImportXml() {
        ImportXmlDialog dialog = new ImportXmlDialog(this.getBridge());
        dialog.setVisible(true);
    }

    private void doImportMp3() {
        ImportFileMp3Dialog dialog = new ImportFileMp3Dialog(this.getBridge());
        dialog.setVisible(true);
    }

    private void doExportToXls() {
        PilotDBDatabase selectedDb = this.getBridge().getSelectedDatabase();
        Plugin plugin = new Plugin();
        plugin.setDatabase(selectedDb);
        plugin.setUp();
        plugin.setPluginMonitor(this.getBridge().getMainWindow());
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setApproveButtonText("Export");
        chooser.setDialogTitle("Export to Excel");
        chooser.setSelectedFile(new File(String.valueOf(selectedDb.getTitle()) + ".xls"));
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                if (arg0.isDirectory()) {
                    return true;
                }
                return arg0.getAbsolutePath().toLowerCase().endsWith(".xls");
            }

            public String getDescription() {
                return "Excel 97 File (*.xls)";
            }
        });
        int val = chooser.showSaveDialog(this.getBridge().getMainComponent());
        File outputFile = null;
        if (val == 0) {
            outputFile = chooser.getSelectedFile();
        }
        try {
            File parent = outputFile.getParentFile();
            String shortname = outputFile.getName();
            if (shortname.toLowerCase().endsWith(".xls")) {
                shortname = shortname.substring(0, shortname.length() - 4);
            }
            File newCsvFile = new File(parent, String.valueOf(shortname) + ".xls");
            plugin.setOutputCsvPath(newCsvFile.getAbsolutePath());
            plugin.execute();
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Exported to " + newCsvFile.getAbsolutePath(), "Done", -1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Error : " + e.toString(), "Error", -1);
            e.printStackTrace();
        }
    }

    private void doExportToRtf() {
        PilotDBDatabase selectedDb = this.getBridge().getSelectedDatabase();
        pilotdb.tools.export.rtf.Plugin plugin = new pilotdb.tools.export.rtf.Plugin();
        plugin.setDatabase(selectedDb);
        plugin.setUp();
        plugin.setPluginMonitor(this.getBridge().getMainWindow());
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setApproveButtonText("Export");
        chooser.setDialogTitle("Export to RTF");
        chooser.setSelectedFile(new File(String.valueOf(selectedDb.getTitle()) + ".rtf"));
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                if (arg0.isDirectory()) {
                    return true;
                }
                return arg0.getAbsolutePath().toLowerCase().endsWith(".rtf");
            }

            public String getDescription() {
                return "RTF File (*.rtf)";
            }
        });
        int val = chooser.showSaveDialog(this.getBridge().getMainComponent());
        File outputFile = null;
        if (val == 0) {
            outputFile = chooser.getSelectedFile();
        }
        if (outputFile == null) {
            return;
        }
        if (outputFile == null) {
            return;
        }
        try {
            File parent = outputFile.getParentFile();
            String shortname = outputFile.getName();
            if (shortname.toLowerCase().endsWith(".rtf")) {
                shortname = shortname.substring(0, shortname.length() - 4);
            }
            File newCsvFile = new File(parent, String.valueOf(shortname) + ".rtf");
            plugin.setOutputRtfPath(newCsvFile.getAbsolutePath());
            plugin.execute();
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Exported to " + newCsvFile.getAbsolutePath(), "Done", -1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Error : " + e.toString(), "Error", -1);
            e.printStackTrace();
        }
    }

    private void doExportToPdf() {
        PilotDBDatabase selectedDb = this.getBridge().getSelectedDatabase();
        pilotdb.tools.export.pdf.Plugin plugin = new pilotdb.tools.export.pdf.Plugin();
        plugin.setDatabase(selectedDb);
        plugin.setUp();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setApproveButtonText("Export");
        chooser.setDialogTitle("Export to PDF");
        chooser.setSelectedFile(new File(String.valueOf(selectedDb.getTitle()) + ".pdf"));
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                if (arg0.isDirectory()) {
                    return true;
                }
                return arg0.getAbsolutePath().toLowerCase().endsWith(".pdf");
            }

            public String getDescription() {
                return "PDF File (*.pdf)";
            }
        });
        int val = chooser.showSaveDialog(this.getBridge().getMainComponent());
        File outputFile = null;
        if (val == 0) {
            outputFile = chooser.getSelectedFile();
        }
        if (outputFile == null) {
            return;
        }
        try {
            File parent = outputFile.getParentFile();
            String shortname = outputFile.getName();
            if (shortname.toLowerCase().endsWith(".pdf")) {
                shortname = shortname.substring(0, shortname.length() - 4);
            }
            File newCsvFile = new File(parent, String.valueOf(shortname) + ".pdf");
            plugin.setOutputRtfPath(newCsvFile.getAbsolutePath());
            plugin.setPluginMonitor(this.getBridge().getMainWindow());
            plugin.execute();
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Exported to " + newCsvFile.getAbsolutePath(), "Done", -1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Error : " + e.toString(), "Error", -1);
            e.printStackTrace();
        }
    }

    private void doExportToXml() {
        PilotDBDatabase selectedDb = this.getBridge().getSelectedDatabase();
        pilotdb.tools.export.xml.Plugin plugin = new pilotdb.tools.export.xml.Plugin();
        plugin.setDatabase(selectedDb);
        plugin.setUp();
        plugin.setPluginMonitor(this.getBridge().getMainWindow());
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setApproveButtonText("Export");
        chooser.setDialogTitle("Export to XML");
        chooser.setSelectedFile(new File(String.valueOf(selectedDb.getTitle()) + ".xml"));
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                if (arg0.isDirectory()) {
                    return true;
                }
                return arg0.getAbsolutePath().toLowerCase().endsWith(".xml");
            }

            public String getDescription() {
                return "XML File (*.xml)";
            }
        });
        int val = chooser.showSaveDialog(this.getBridge().getMainComponent());
        File outputFile = null;
        if (val == 0) {
            outputFile = chooser.getSelectedFile();
        }
        if (outputFile == null) {
            return;
        }
        try {
            plugin.setOutputXmlPath(outputFile.getAbsolutePath());
            plugin.execute();
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Exported to " + outputFile.getAbsolutePath(), "Done", -1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Error : " + e.toString(), "Error", -1);
            e.printStackTrace();
        }
    }

    private void doExportToCsv() {
        PilotDBDatabase selectedDb = this.getBridge().getSelectedDatabase();
        pilotdb.tools.export.csv.Plugin plugin = new pilotdb.tools.export.csv.Plugin();
        plugin.setDatabase(selectedDb);
        plugin.setUp();
        plugin.setPluginMonitor(this.getBridge().getMainWindow());
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setApproveButtonText("Export");
        chooser.setDialogTitle("Export to CSV");
        chooser.setSelectedFile(new File(String.valueOf(selectedDb.getTitle()) + ".csv"));
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                if (arg0.isDirectory()) {
                    return true;
                }
                return arg0.getAbsolutePath().toLowerCase().endsWith(".csv");
            }

            public String getDescription() {
                return "CSV File (*.csv)";
            }
        });
        int val = chooser.showSaveDialog(this.getBridge().getMainComponent());
        File outputFile = null;
        if (val == 0) {
            outputFile = chooser.getSelectedFile();
        }
        try {
            File parent = outputFile.getParentFile();
            String shortname = outputFile.getName();
            if (shortname.toLowerCase().endsWith(".csv")) {
                shortname = shortname.substring(0, shortname.length() - 4);
            }
            File newCsvFile = new File(parent, String.valueOf(shortname) + ".csv");
            File newIfoFile = new File(parent, String.valueOf(shortname) + ".ifo");
            plugin.setOutputCsvPath(newCsvFile.getAbsolutePath());
            plugin.setOutputIfoPath(newIfoFile.getAbsolutePath());
            plugin.execute();
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Exported to " + newCsvFile.getAbsolutePath(), "Done", -1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Error : " + e.toString(), "Error", -1);
            e.printStackTrace();
        }
    }

    private void doExportToHtml() {
        PilotDBDatabase selectedDb = this.getBridge().getSelectedDatabase();
        pilotdb.tools.export.html.Plugin plugin = new pilotdb.tools.export.html.Plugin();
        plugin.setDatabase(selectedDb);
        plugin.setUp();
        plugin.setPluginMonitor(this.getBridge().getMainWindow());
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setApproveButtonText("Export");
        chooser.setDialogTitle("Export to HTML");
        chooser.setSelectedFile(new File(String.valueOf(selectedDb.getTitle()) + ".html"));
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                if (arg0.isDirectory()) {
                    return true;
                }
                return arg0.getAbsolutePath().toLowerCase().endsWith(".html");
            }

            public String getDescription() {
                return "HTML File (*.html)";
            }
        });
        int val = chooser.showSaveDialog(this.getBridge().getMainComponent());
        File outputFile = null;
        if (val == 0) {
            outputFile = chooser.getSelectedFile();
        }
        if (outputFile == null) {
            return;
        }
        try {
            plugin.setOutputHtmlPath(outputFile.getAbsolutePath());
            plugin.execute();
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Exported to " + outputFile.getAbsolutePath(), "Done", -1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Error : " + e.toString(), "Error", -1);
            e.printStackTrace();
        }
    }
}

