/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBEnvironment;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.AbstractCommandHandler;

public class FileCommandsHandler
extends AbstractCommandHandler {
    JFileChooser chooser = new JFileChooser();
    Component mainComponent = null;

    public FileCommandsHandler(Application bridge) {
        super(bridge);
        this.chooser.setFileSelectionMode(1);
        this.mainComponent = bridge.getMainComponent();
        this.chooser.setApproveButtonText("Select");
        this.chooser.setDialogTitle("Select a Directory");
        this.chooser.setFileHidingEnabled(false);
    }

    public void handle(Command evt) {
        String cmd = evt.getActionCommand();
        if (cmd == null) {
            cmd = "";
        }
        if (evt.equals("cmd-open-directory")) {
            this.doOpen();
        } else if (evt.equals("cmd-exit")) {
            this.doExit();
        } else if (evt.equals("cmd-install-database")) {
            PilotDBDatabase pdd = null;
            pdd = evt.getAttachedObject() == null ? this.getBridge().getSelectedDatabase() : (PilotDBDatabase)evt.getAttachedObject();
            File f = PilotDBEnvironment.getEnvironment(pdd).getFile(pdd);
            String path = f.getAbsolutePath();
            String installAppPath = this.getBridge().getUserPreferences().getInstallExecutablePath();
            if (installAppPath == null || installAppPath.length() == 0) {
                JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "You must set the install application executable path\n in the preferences");
                return;
            }
            try {
                File instAppExe = new File(installAppPath);
                String args = this.getBridge().getUserPreferences().getInstallArgs();
                String[] argss = args.split(" ");
                String[] commandLine = new String[argss.length + 1];
                commandLine[0] = installAppPath;
                System.arraycopy(argss, 0, commandLine, 1, argss.length);
                int i = 0;
                while (i < commandLine.length) {
                    commandLine[i] = MessageFormat.format(commandLine[i], path);
                    ++i;
                }
                Runtime.getRuntime().exec(commandLine);
            }
            catch (Exception e) {
                Command uhoh = new Command(this, "cmd-show-error", e);
                this.getBridge().postEvent(uhoh);
            }
        } else if (evt.equals("cmd-commit-database")) {
            PilotDBDatabase pdd = null;
            pdd = evt.getAttachedObject() == null ? this.getBridge().getSelectedDatabase() : (PilotDBDatabase)evt.getAttachedObject();
            boolean installOnCommit = this.getBridge().getUserPreferences().isInstallOnCommit();
            if (installOnCommit) {
                Command c = new Command(this, "cmd-install-database", pdd);
                this.getBridge().postEvent(c);
            }
        }
        super.handle(evt);
    }

    private void doExit() {
        String msg = "Save changes to ";
        int options = 1;
        PilotDBEnvironment env = null;
        try {
            env = this.getBridge().getCurrentEnvironment();
            PilotDBDatabase[] dirtyboys = env.getDirtyDatabases();
            int i = 0;
            while (i < dirtyboys.length) {
                String dbtitle = dirtyboys[i].getTitle();
                int response = JOptionPane.showConfirmDialog(this.getBridge().getMainComponent(), String.valueOf(msg) + "'" + dbtitle + "' ?", "Exit", options);
                switch (response) {
                    case 0: {
                        Command saveCommand = new Command(this, "cmd-commit-database", dirtyboys[i]);
                        this.getBridge().postEventAndWait(saveCommand);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
                ++i;
            }
            System.exit(0);
        }
        catch (Exception e) {
            Command c = new Command(this, "cmd-log-exception", e);
            this.getBridge().postEvent(c);
        }
    }

    private void doOpen() {
        try {
            int val = this.chooser.showOpenDialog(this.mainComponent);
            if (val == 0) {
                File f = this.chooser.getSelectedFile();
                this.bridge.openEnvironment(f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

