/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import pilotdb.ui.Application;
import pilotdb.ui.UserPreferences;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.AbstractCommandHandler;

public class LogCommandHandler
extends AbstractCommandHandler {
    boolean configured = false;

    public LogCommandHandler(Application bridge) {
        super(bridge);
    }

    private void configure() {
        if (this.configured) {
            return;
        }
        UserPreferences prefs = this.bridge.getUserPreferences();
        Category root = Category.getRoot();
        root.removeAllAppenders();
        String level = prefs.getLogLevel();
        Priority p = Priority.DEBUG;
        if (level.equalsIgnoreCase("debug")) {
            p = Priority.DEBUG;
        } else if (level.equalsIgnoreCase("error")) {
            p = Priority.ERROR;
        } else if (level.equalsIgnoreCase("info")) {
            p = Priority.INFO;
        }
        root.setPriority(p);
        String appenderType = prefs.getLogType();
        WriterAppender appender = null;
        PatternLayout layout = new PatternLayout("[%c{1}] %m%n");
        if (appenderType.equalsIgnoreCase("file")) {
            try {
                String filename = prefs.getLogFile();
                FileAppender fa = new FileAppender(layout, filename, false);
                fa.setName("File Appender");
                appender = fa;
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
        }
        if (appender == null) {
            ConsoleAppender ca = new ConsoleAppender((Layout)layout, "System.err");
            ca.setName("Console Appender");
            appender = ca;
        }
        if (appender != null) {
            root.addAppender(appender);
        }
        this.configured = true;
    }

    public void handle(Command evt) {
        super.handle(evt);
        if (evt.equals("cmd-log-debug")) {
            this.configure();
            Object source = evt.getSource();
            Category log = Category.getInstance(source.getClass());
            log.debug(evt.getAttachedObject().toString());
        } else if (evt.equals("cmd-log-error")) {
            this.configure();
            Object source = evt.getSource();
            Category log = Category.getInstance(source.getClass());
            log.error(evt.getAttachedObject().toString());
        } else if (evt.equals("cmd-log-exception")) {
            this.configure();
            Object source = evt.getSource();
            Category log = Category.getInstance(source.getClass());
            log.error((Exception)evt.getAttachedObject(), (Exception)evt.getAttachedObject());
        } else if (evt.equals("cmd-show-error")) {
            String error = String.valueOf(evt.getAttachedObject());
            Component c = null;
            c = evt.getSource() instanceof Component ? (Component)evt.getSource() : this.getBridge().getMainWindow();
            int response = JOptionPane.showConfirmDialog(c, "An unexpected error has occured:\n" + error + "\n\nWould you like to notify the developer?", "Error", 0, 0);
            if (response == 0) {
                StringWriter sw = new StringWriter();
                sw.write("Error:" + error + "\n");
                if (evt.getAttachedObject() instanceof Exception) {
                    Exception e = (Exception)evt.getAttachedObject();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    pw.flush();
                }
                Command command = new Command(evt.getSource(), "cmd-showfeedbackapplet", sw.toString());
                this.getBridge().postEvent(command);
            }
        } else if (evt.equals("cmd-show-msg")) {
            String error = String.valueOf(evt.getAttachedObject());
            Component c = null;
            c = evt.getSource() instanceof Component ? (Component)evt.getSource() : this.getBridge().getMainWindow();
            JOptionPane.showMessageDialog(c, error, "JPilot-DB", 1);
        }
    }
}

