/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBEnvironment;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.AbstractCommandHandler;
import pilotdb.ui.databaselist.DatabaseList;
import pilotdb.ui.recordsetview.DynamicForm;
import pilotdb.ui.recordsetview.RecordsetList;

public class MenuHandler
extends AbstractCommandHandler {
    public MenuHandler(Application app) {
        super(app);
    }

    public void handle(Command evt) {
        if (evt.getActionCommand().startsWith("mnu-")) {
            if (evt.equals("mnu-delete-database")) {
                DatabaseList dl = this.getBridge().getMainWindow().getDatabaseListFrame();
                PilotDBDatabase[] dbs = dl.getSelectedDatabases();
                int i = 0;
                while (i < dbs.length) {
                    PilotDBDatabase db = dbs[i];
                    String dbname = db.getTitle();
                    int response = JOptionPane.showConfirmDialog(this.bridge.getMainComponent(), "Are you sure you want to\ndelete the '" + dbname + "' database?", "Delete Database", 0);
                    if (response == 1) {
                        return;
                    }
                    Command c = new Command(this, "cmd-delete-database", db);
                    this.bridge.postEvent(c);
                    ++i;
                }
            } else if (evt.equals("mnu-commit-database")) {
                DatabaseList dl = this.getBridge().getMainWindow().getDatabaseListFrame();
                PilotDBDatabase[] dbs = dl.getSelectedDatabases();
                int i = 0;
                while (i < dbs.length) {
                    PilotDBDatabase db = dbs[i];
                    String dbname = db.getTitle();
                    Command c = new Command(this, "cmd-commit-database", db);
                    this.bridge.postEvent(c);
                    ++i;
                }
            } else if (evt.equals("mnu-commit-databases")) {
                PilotDBEnvironment pde = this.getBridge().getCurrentEnvironment();
                int i = 0;
                while (i < pde.getDatabaseCount()) {
                    PilotDBDatabase pdb = pde.getDatabase(i);
                    if (pdb.isDirty()) {
                        Command c = new Command(this, "cmd-commit-database", pdb);
                        this.bridge.postEvent(c);
                    }
                    ++i;
                }
            } else if (evt.getActionCommand().equals("mnu-edit-record")) {
                JInternalFrame jif = this.getBridge().getMainWindow().getDesktop().getSelectedFrame();
                PilotDBRecord pdr = null;
                if (jif instanceof DynamicForm) {
                    DynamicForm df = (DynamicForm)jif;
                    pdr = df.getRecord();
                } else if (jif instanceof RecordsetList) {
                    RecordsetList rl = (RecordsetList)jif;
                    pdr = rl.getSelectedRecord();
                }
                Command command = new Command(evt.getSource(), "cmd-edit-record", pdr);
                this.getBridge().postEvent(command);
            } else {
                String commandName = evt.getActionCommand().substring(4, evt.getActionCommand().length());
                Command c = new Command(evt.getSource(), "cmd-".concat(commandName), null);
                this.bridge.postEventAndWait(c);
            }
        } else {
            super.handle(evt);
        }
    }
}

