/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBEnvironment;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.AbstractCommandHandler;
import pilotdb.ui.tablemaker.SchemaEditModel;
import pilotdb.ui.tablemaker.TableMakerInternalFrame;

public class TableMakerCommandHandler
extends AbstractCommandHandler {
    private SchemaEditModel tableMakerModel = null;

    public TableMakerCommandHandler(Application bridge) {
        super(bridge);
    }

    public void handle(Command event) {
        if (event.equals("cmd-create-tablefrommodel")) {
            this.setTableMakerModel((SchemaEditModel)event.getAttachedObject());
            try {
                this.createTableFromModel();
            }
            catch (Exception e) {
                this.getBridge().postEvent(new Command(this, "cmd-log-exception", e));
            }
        } else if (event.equals("cmd-show-tablemakergui")) {
            TableMakerInternalFrame tmif = new TableMakerInternalFrame(this.getBridge());
            tmif.setVisible(true);
        }
        super.handle(event);
    }

    public void createTableFromModel() throws Exception {
        SchemaEditModel model = this.getTableMakerModel();
        PilotDBDatabase db = new PilotDBDatabase(model.getName(), "DB00", "DBOS", model.getSchema());
        PilotDBEnvironment env = this.getBridge().getCurrentEnvironment();
        env.add(db);
        this.getBridge().postEvent(new Command(this, "msg-created-database", db));
        this.getBridge().postEvent(new Command(this, "msg-status", "Created table " + model.getName()));
    }

    public SchemaEditModel getTableMakerModel() {
        return this.tableMakerModel;
    }

    public void setTableMakerModel(SchemaEditModel tableMakerModel) {
        this.tableMakerModel = tableMakerModel;
    }
}

