/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import java.util.Vector;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBSchema;
import pilotdb.PilotDBView;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.AbstractCommandHandler;
import pilotdb.ui.viewmaker.DBViewMakerModel;
import pilotdb.ui.viewmaker.ViewListInternalFrame;
import pilotdb.ui.viewmaker.ViewMakerInternalFrame;

public class ViewMakerCommandHandler
extends AbstractCommandHandler {
    public ViewMakerCommandHandler(Application bridge) {
        super(bridge);
    }

    public void handle(Command event) {
        if (event.equals("cmd-create-view-from-model")) {
            try {
                DBViewMakerModel model = (DBViewMakerModel)event.getAttachedObject();
                if (model.getOldName() != null) {
                    PilotDBDatabase database = this.getBridge().getSelectedDatabase();
                    database.removeView(model.getOldName());
                }
                this.createViewFromModel(model);
                this.getBridge().postEvent(new Command(this, "msg-created-view", null));
            }
            catch (Exception e) {
                this.getBridge().postEvent(new Command(this, "log-exception", e));
            }
        } else if (event.equals("cmd-show-view-maker-gui")) {
            PilotDBView viewToEdit = (PilotDBView)event.getAttachedObject();
            PilotDBDatabase db = this.getBridge().getSelectedDatabase();
            if (db == null) {
                return;
            }
            PilotDBSchema schema = db.getSchema();
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < schema.getFieldCount()) {
                v.add(schema.getField(i).getName());
                ++i;
            }
            DBViewMakerModel model = new DBViewMakerModel(v);
            if (viewToEdit != null) {
                model.updateFrom(viewToEdit);
            }
            ViewMakerInternalFrame tmif = new ViewMakerInternalFrame(this.getBridge(), model);
            tmif.setVisible(true);
        } else if (event.equals("cmd-showviewlistgui")) {
            ViewListInternalFrame tmif = new ViewListInternalFrame(this.getBridge());
            tmif.setVisible(true);
        }
        super.handle(event);
    }

    public void createViewFromModel(DBViewMakerModel viewMakerModel) throws Exception {
        PilotDBDatabase database = this.getBridge().getSelectedDatabase();
        if (database == null) {
            return;
        }
        DBViewMakerModel model = viewMakerModel;
        if (model == null) {
            throw new Exception("Model cannot be null!");
        }
        String name = model.getName();
        PilotDBView view = database.createView(name);
        int i = 0;
        while (i < model.getFieldCount()) {
            name = model.getFieldName(i);
            int len = model.getFieldWidth(i);
            if (model.isFieldVisible(i)) {
                view.addColumn(name, (short)len);
            }
            ++i;
        }
        database.markAsDirty();
        this.getBridge().postEvent(new Command(this, "msg-created-view", view));
        this.getBridge().postEvent(new Command(this, "cmd-show-status", "Created view " + name));
    }
}

