/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.databaselist;

import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBEnvironment;

public class DBListTableModel
extends AbstractTableModel {
    PilotDBEnvironment environment = null;
    String[] columnNames = new String[]{"Title", "File", "Dirty", "Records", "Warnings"};
    List pilotdbs = new LinkedList();

    public void setEnvironment(Component c, File env) throws IOException {
        this.environment = PilotDBEnvironment.getEnvironment(env);
        this.reloadDatabases(c);
        this.fireTableDataChanged();
    }

    public File getEnvironment() {
        return this.environment.getBaseDirectory();
    }

    public int getRowCount() {
        return this.pilotdbs.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Object getValueAt(int row, int col) {
        PilotDBDatabase db = (PilotDBDatabase)this.pilotdbs.get(row);
        switch (col) {
            case 0: {
                return db.getTitle();
            }
            case 1: {
                try {
                    File f = this.environment.getFile(db);
                    return f.getName();
                }
                catch (Exception e) {
                    return "!ERROR : " + e.toString();
                }
            }
            case 2: {
                return db.isDirty() ? "yes" : "no";
            }
            case 3: {
                return String.valueOf(db.getRecordCount());
            }
            case 4: {
                if (!db.hasWarnings()) {
                    return "none";
                }
                Iterator warnings = db.getWarnings();
                StringBuffer sb = new StringBuffer();
                while (warnings.hasNext()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(warnings.next());
                    sb.append("\n");
                }
                return sb.toString();
            }
        }
        return "error";
    }

    public PilotDBDatabase getDatabase(int row) {
        return (PilotDBDatabase)this.pilotdbs.get(row);
    }

    public void reloadDatabases(Component comp) {
        if (this.environment == null) {
            return;
        }
        this.pilotdbs.clear();
        File f = this.environment.getBaseDirectory();
        File[] pdbs = f.listFiles(new FileFilter(){

            public boolean accept(File f) {
                boolean endsWithPdb = f.getAbsolutePath().toLowerCase().endsWith(".pdb");
                if (!endsWithPdb) {
                    return false;
                }
                try {
                    return PilotDBDatabase.isProbablyPilotDB(new FileInputStream(f));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        });
        int i = 0;
        while (i < pdbs.length) {
            f = pdbs[i];
            try {
                String rel = f.getName();
                PilotDBDatabase db = this.environment.openDatabaseByFilename(rel);
                this.pilotdbs.add(db);
            }
            catch (Exception e) {
                try {
                    System.err.println("Unable to open:" + f.getCanonicalPath());
                    e.printStackTrace();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.fireTableDataChanged();
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }
}

