/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.Messages;
import pilotdb.ui.recordsetview.EditorComponent;
import pilotdb.ui.util.UnderlineLabel;

public class DateEditor
extends JPanel
implements EditorComponent {
    JTextField jtfYear = new JTextField();
    JTextField jtfMonth = new JTextField();
    JTextField jtfDate = new JTextField();
    UnderlineLabel jlDate = new UnderlineLabel();

    public DateEditor() {
        this.jtfYear.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfMonth.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfDate.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setLayout(null);
        this.jtfYear.setBounds(0, 0, 60, 20);
        this.jtfMonth.setBounds(65, 0, 40, 20);
        this.jtfDate.setBounds(110, 0, 40, 20);
        this.jlDate.setBounds(0, 0, 150, 20);
        this.jlDate.setDrawLineFullWidth(true);
        this.add(this.jtfYear);
        this.add(this.jtfMonth);
        this.add(this.jtfDate);
        this.add(this.jlDate);
        this.setPreferredSize(new Dimension(150, 25));
    }

    public Component getEditorComponent() {
        return this.jtfYear;
    }

    public boolean isValid() {
        try {
            String year = this.jtfYear.getText();
            String month = this.jtfMonth.getText();
            String date = this.jtfDate.getText();
            new PilotDBDate(String.valueOf(year) + "/" + month + "/" + date);
            this.jtfYear.setForeground(Color.black);
            this.jtfMonth.setForeground(Color.black);
            this.jtfDate.setForeground(Color.black);
            return true;
        }
        catch (Exception e) {
            this.jtfYear.setForeground(Color.red);
            this.jtfMonth.setForeground(Color.red);
            this.jtfDate.setForeground(Color.red);
            return false;
        }
    }

    public String getInvalidReason() {
        return String.valueOf(Messages.getString("DateEditor.InvalidDateValue")) + this.getName();
    }

    public void display(PilotDBRecord record, int fieldIndex) throws Exception {
        PilotDBDate theDate = record.getDate(fieldIndex);
        if (theDate == null) {
            return;
        }
        this.jlDate.setText(theDate.toString());
        this.jtfYear.setVisible(false);
        this.jtfMonth.setVisible(false);
        this.jtfDate.setVisible(false);
        this.jlDate.setVisible(true);
    }

    public void stopEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jtfYear.setEnabled(false);
        this.jtfMonth.setEnabled(false);
        this.jtfDate.setEnabled(false);
        String year = this.jtfYear.getText();
        String month = this.jtfMonth.getText();
        String date = this.jtfDate.getText();
        PilotDBDate newDate = new PilotDBDate(String.valueOf(year) + "/" + month + "/" + date);
        record.setDate(fieldIndex, newDate);
    }

    public void startEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jlDate.setVisible(false);
        this.jtfYear.setEnabled(true);
        this.jtfMonth.setEnabled(true);
        this.jtfDate.setEnabled(true);
        this.jtfYear.setVisible(true);
        this.jtfMonth.setVisible(true);
        this.jtfDate.setVisible(true);
        PilotDBDate theDate = record.getDate(fieldIndex);
        if (theDate == null) {
            return;
        }
        this.jtfYear.setText(String.valueOf(theDate.getYear()));
        this.jtfMonth.setText(String.valueOf(theDate.getMonth()));
        this.jtfDate.setText(String.valueOf(theDate.getDate()));
    }

    public void cancelEditing(PilotDBRecord record, int fieldIndex) {
        this.jtfYear.setEnabled(false);
        this.jtfMonth.setEnabled(false);
        this.jtfDate.setEnabled(false);
        try {
            PilotDBDate theDate = record.getDate(fieldIndex);
            if (theDate == null) {
                return;
            }
            this.jtfYear.setText(String.valueOf(theDate.getYear()));
            this.jtfMonth.setText(String.valueOf(theDate.getMonth()));
            this.jtfDate.setText(String.valueOf(theDate.getDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBridge(Application bridge) {
    }
}

