/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.Messages;
import pilotdb.ui.recordsetview.EditorComponent;
import pilotdb.ui.util.UnderlineLabel;

public class FloatEditor
extends JPanel
implements EditorComponent {
    JTextField jtf = new JTextField();
    UnderlineLabel jl = new UnderlineLabel();

    public FloatEditor() {
        this.jtf.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setLayout(null);
        this.jl.setDrawLineFullWidth(true);
        this.jtf.setBounds(0, 0, 150, 20);
        this.jl.setBounds(0, 0, 150, 20);
        this.add(this.jtf);
        this.add(this.jl);
        this.setPreferredSize(new Dimension(150, 25));
    }

    public Component getEditorComponent() {
        return this.jtf;
    }

    public boolean isValid() {
        try {
            Float.parseFloat(this.jtf.getText());
            this.jtf.setForeground(Color.black);
            return true;
        }
        catch (Exception e) {
            this.jtf.setForeground(Color.red);
            return false;
        }
    }

    public String getInvalidReason() {
        return String.valueOf(Messages.getString("FloatEditor.InvalidFloatValue")) + this.getName();
    }

    public void display(PilotDBRecord record, int fieldIndex) throws Exception {
        double f = record.getFloat(fieldIndex);
        this.jl.setText(String.valueOf(f));
        this.jtf.setVisible(false);
        this.jl.setVisible(true);
    }

    public void stopEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jtf.setEnabled(false);
        String s = this.jtf.getText();
        record.setFloat(fieldIndex, Double.parseDouble(s));
    }

    public void startEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jl.setVisible(false);
        this.jtf.setEnabled(true);
        this.jtf.setVisible(true);
        double d = record.getFloat(fieldIndex);
        this.jtf.setText(String.valueOf(d));
    }

    public void cancelEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jtf.setEnabled(false);
        double d = record.getFloat(fieldIndex);
        this.jtf.setText(String.valueOf(d));
    }

    public void setBridge(Application bridge) {
    }
}

