/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import pilotdb.PilotDBField;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.recordsetview.EditorComponent;
import pilotdb.ui.util.UnderlineLabel;

public class ListEditor
extends JPanel
implements EditorComponent {
    DefaultComboBoxModel model = new DefaultComboBoxModel();
    JComboBox jcb = new JComboBox(this.model);
    UnderlineLabel jl = new UnderlineLabel();

    public ListEditor() {
        this.jcb.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setLayout(null);
        this.jcb.setBounds(0, 0, 150, 20);
        this.jl.setBounds(0, 0, 150, 20);
        this.jl.setDrawLineFullWidth(true);
        this.add(this.jcb);
        this.add(this.jl);
        this.setPreferredSize(new Dimension(150, 25));
    }

    public boolean isValid() {
        return true;
    }

    public Component getEditorComponent() {
        return this;
    }

    public String getInvalidReason() {
        return null;
    }

    public void display(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jcb.setEnabled(false);
        this.jl.setVisible(true);
        this.jcb.setVisible(false);
        this.jl.setText(record.getListChoice(fieldIndex));
    }

    public void stopEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        record.setList(fieldIndex, this.jcb.getSelectedIndex());
        this.jcb.setEnabled(false);
    }

    public void startEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        PilotDBField field = record.getSchema().getField(fieldIndex);
        this.model.removeAllElements();
        int i = 0;
        while (i < field.getListChoiceCount()) {
            this.model.addElement(field.getListChoice(i));
            ++i;
        }
        this.jcb.setVisible(true);
        this.jl.setVisible(false);
        this.jcb.setEnabled(true);
        this.jcb.setSelectedIndex(record.getList(fieldIndex));
    }

    public void cancelEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jcb.setEnabled(false);
        this.jl.setText(record.getListChoice(fieldIndex));
    }

    public void setBridge(Application bridge) {
    }
}

