/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.io.File;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.Messages;
import pilotdb.ui.command.Command;
import pilotdb.ui.images.Images;
import pilotdb.ui.recordsetview.RecordsetViewPanel;

public class RecordsetList
extends JInternalFrame {
    Application bridge;
    PilotDBDatabase database;
    RecordsetViewPanel recordsetViewPanel = new RecordsetViewPanel();

    public RecordsetList(Application bridge) {
        super(Messages.getString("RecordsetList.RecordList"));
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setClosable(true);
        this.setResizable(true);
        this.setFrameIcon(Images.RECORDSET_VIEW_ICON);
        this.bridge = bridge;
        this.recordsetViewPanel.setApplication(this.bridge);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.recordsetViewPanel);
        this.pack();
        this.setLocation(40, 40);
        this.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameOpened(InternalFrameEvent arg0) {
            }

            public void internalFrameClosing(InternalFrameEvent arg0) {
            }

            public void internalFrameClosed(InternalFrameEvent arg0) {
            }

            public void internalFrameIconified(InternalFrameEvent arg0) {
            }

            public void internalFrameDeiconified(InternalFrameEvent arg0) {
            }

            public void internalFrameActivated(InternalFrameEvent arg0) {
                RecordsetList.this.onActivate();
            }

            public void internalFrameDeactivated(InternalFrameEvent arg0) {
            }
        });
        bridge.getMainWindow().getDesktop().add(this);
        this.setVisible(true);
    }

    private void onActivate() {
        Command c;
        Command ce = new Command(this, "cmd-log-debug", "dynamic form activated");
        this.bridge.postEvent(ce);
        if (this.database != null) {
            c = new Command(this, "msg-selected-database", this.database);
            this.bridge.postEvent(c);
        }
        c = new Command(this, "msg-window-activated", this);
        this.bridge.postEvent(c);
        c = new Command(this, "msg-windowstate-changed", this);
        this.bridge.postEvent(c);
    }

    public Application getBridge() {
        return this.bridge;
    }

    public PilotDBDatabase getDatabase() {
        return this.database;
    }

    public void setBridge(Application bridge) {
        this.bridge = bridge;
        this.recordsetViewPanel.setApplication(bridge);
    }

    public void setDatabase(PilotDBDatabase database) {
        this.database = database;
        File f = this.bridge.getCurrentEnvironment().getFile(database);
        this.setName(f.getName());
        this.setTitle(String.valueOf(database.getTitle()) + " " + Messages.getString("RecordsetList.Records"));
        this.recordsetViewPanel.setDatabase(database);
    }

    public PilotDBRecord getSelectedRecord() {
        return this.recordsetViewPanel.getSelectedRecord();
    }

    public void delete() {
        this.recordsetViewPanel.delete();
    }

    public void refreshTableData() {
        this.recordsetViewPanel.refreshTableData();
    }

    public void sizeColumns() {
        this.recordsetViewPanel.sizeColumns();
    }
}

