/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBField;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Messages;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.CommandConduit;

public class RecordsetTableModel
extends AbstractTableModel {
    protected PilotDBDatabase database;
    protected String viewName = null;
    private CommandConduit commandConduit;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public CommandConduit getCommandConduit() {
        return this.commandConduit;
    }

    public void setCommandConduit(CommandConduit conduit) {
        this.commandConduit = conduit;
    }

    public PilotDBRecord getRecord(int idx) {
        return (PilotDBRecord)this.database.getRecord(idx);
    }

    public void setDatabase(PilotDBDatabase db) {
        this.database = db;
        this.fireTableStructureChanged();
    }

    public PilotDBDatabase getDatabase() {
        return this.database;
    }

    public void setViewName(String name) {
        this.viewName = name;
        this.fireTableStructureChanged();
    }

    public String getViewName() {
        return this.viewName;
    }

    public int getActualColumn(int column) {
        if (this.viewName == null) {
            return column;
        }
        return this.database.getView(this.viewName).getColumn(column).getFieldNumber();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (this.database.getSchema().getField(this.getActualColumn(columnIndex)).getType()) {
            case 5: 
            case 9: {
                return false;
            }
        }
        return false;
    }

    public int getColumnCount() {
        if (this.database == null) {
            return 0;
        }
        if (this.viewName == null) {
            return this.database.getSchema().getFieldCount();
        }
        return this.database.getView(this.viewName).getColumnCount();
    }

    public String getColumnName(int column) {
        if (this.database == null) {
            return null;
        }
        return this.database.getSchema().getField(this.getActualColumn(column)).getName();
    }

    public Object getValueAt(int row, int col) {
        if (this.database == null) {
            return null;
        }
        Object obj = null;
        PilotDBRecord r = (PilotDBRecord)this.database.getRecord(row);
        try {
            PilotDBField field = r.getSchema().getField(col);
            obj = field.getType() == 5 ? r.getNoteTitle(this.getActualColumn(col)) : r.getObject(this.getActualColumn(col));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj == null ? Messages.getString("RecordsetTableModel.NA") : obj;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        PilotDBRecord r = (PilotDBRecord)this.database.getRecord(rowIndex);
        try {
            r.setObject(this.getActualColumn(columnIndex), aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
            if (this.commandConduit != null) {
                Command ce = new Command(this, "record-changed", r);
                this.commandConduit.postEvent(ce);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getRowCount() {
        if (this.database == null) {
            return 0;
        }
        return this.database.getRecordCount();
    }

    public Class getColumnClass(int columnIndex) {
        if (this.database == null) {
            return null;
        }
        PilotDBField field = this.database.getSchema().getField(this.getActualColumn(columnIndex));
        switch (field.getType()) {
            case 1: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 8: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 0: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 4: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 6: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 7: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 5: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 10: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 9: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        throw new RuntimeException("Not Yet Implemented");
    }

    public static final void main(String[] a) throws Exception {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("pilotdb.ui.recordsetview.RecordsetTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PilotDBDatabase db = new PilotDBDatabase(clazz.getResourceAsStream("/movies.pdb"));
        RecordsetTableModel model = new RecordsetTableModel();
        model.setDatabase(db);
        JTable table = new JTable(model);
        JScrollPane jsp = new JScrollPane(table);
        JFrame jf = new JFrame();
        jf.setDefaultCloseOperation(3);
        jf.getContentPane().add((Component)jsp, "Center");
        jf.setSize(640, 480);
        jf.setVisible(true);
    }
}

