/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBView;
import pilotdb.ui.Application;
import pilotdb.ui.Messages;
import pilotdb.ui.UserPreferences;
import pilotdb.ui.command.Command;
import pilotdb.ui.images.Images;
import pilotdb.ui.recordsetview.RecordsetTableModel;
import pilotdb.ui.util.FlatTableCellRenderer;
import pilotdb.ui.util.UIBanner;

public class RecordsetViewPanel
extends JPanel
implements MouseListener,
ActionListener,
ItemListener {
    Application application = null;
    RecordsetTableModel tableModel = new RecordsetTableModel();
    FlatTableCellRenderer ftcr2;
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jspRecords = new JScrollPane();
    JTable jtblRecords = new JTable();
    JPanel jPanel1 = new JPanel();
    UIBanner uibanner = new UIBanner(Messages.getString("RecordsetViewPanel.TableData"), 500, null);
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout(0, 0, 0);
    JComboBox jcbViews = new JComboBox();
    JLabel jLabel1 = new JLabel();
    JPopupMenu jpm;
    JMenuItem jmiAddRow;
    JMenuItem jmiEditRow;
    JMenuItem jmiDeleteRow;
    JMenuItem jmiOpen;
    JMenuItem jmiSortAscending;
    JMenuItem jmiSortDescending;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public RecordsetViewPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PilotDBRecord getSelectedRecord() {
        int selectedRow = this.jtblRecords.getSelectedRow();
        if (selectedRow < 0) {
            return null;
        }
        PilotDBRecord record = (PilotDBRecord)this.tableModel.getDatabase().getRecord(selectedRow);
        return record;
    }

    public void delete() {
        this.deleteClicked(null);
    }

    public void refreshTableData() {
        this.tableModel.fireTableDataChanged();
    }

    public void setDatabase(PilotDBDatabase db) {
        this.tableModel.setDatabase(db);
        this.jcbViews.setModel(new ViewComboBoxModel(db));
        this.uibanner.setText(String.valueOf(db.getTitle()) + " : " + db.getRecordCount() + " " + Messages.getString("RecordsetViewPanel.Records"));
        Command c = new Command(this, "msg-windowstate-changed", this);
        this.getApplication().postEvent(c);
        UserPreferences.DbPrefs p = this.getApplication().getUserPreferences().getDatabasePrefs(db.getTitle());
        if (p != null) {
            int i = 0;
            while (i < this.tableModel.getColumnCount()) {
                String columnName = this.tableModel.getColumnName(i);
                UserPreferences.Column col = p.getColumn(columnName);
                if (col != null) {
                    this.jtblRecords.getColumnModel().getColumn(i).setPreferredWidth(col.width);
                }
                ++i;
            }
        }
        this.jtblRecords.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnMarginChanged(ChangeEvent arg0) {
                RecordsetViewPanel.this.updateColumnWidthPreferences();
            }

            public void columnSelectionChanged(ListSelectionEvent arg0) {
            }

            public void columnAdded(TableColumnModelEvent arg0) {
            }

            public void columnMoved(TableColumnModelEvent arg0) {
            }

            public void columnRemoved(TableColumnModelEvent arg0) {
            }
        });
    }

    public void setApplication(Application bridge) {
        this.application = bridge;
        this.tableModel.setCommandConduit(bridge);
    }

    public Application getApplication() {
        return this.application;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jtblRecords.setAutoResizeMode(0);
        this.jtblRecords.setModel(this.tableModel);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.flowLayout1);
        this.setPreferredSize(new Dimension(300, 250));
        this.jLabel1.setDisplayedMnemonic('V');
        this.jLabel1.setLabelFor(this.jcbViews);
        this.jLabel1.setText(Messages.getString("RecordsetViewPanel.View"));
        this.jcbViews.addItemListener(this);
        this.jspRecords.setBorder(null);
        this.jspRecords.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtblRecords.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getClickCount() > 1) {
                    RecordsetViewPanel.this.onTableDoubleClick();
                }
                Command c = new Command(this, "msg-windowstate-changed", this);
                RecordsetViewPanel.this.application.postEvent(c);
            }

            public void mousePressed(MouseEvent arg0) {
                if (arg0.isPopupTrigger() && RecordsetViewPanel.this.jtblRecords.getSelectedRow() > -1) {
                    RecordsetViewPanel.this.jpm.show(RecordsetViewPanel.this.jtblRecords, arg0.getX(), arg0.getY());
                } else if (RecordsetViewPanel.this.jtblRecords.getSelectedRow() > -1) {
                    RecordsetViewPanel.this.getApplication().postEvent(new Command(this, "msg-selected-record", RecordsetViewPanel.this.getSelectedRecord()));
                }
            }

            public void mouseReleased(MouseEvent arg0) {
                if (arg0.isPopupTrigger() && RecordsetViewPanel.this.jtblRecords.getSelectedRow() > -1) {
                    RecordsetViewPanel.this.jpm.show(RecordsetViewPanel.this.jtblRecords, arg0.getX(), arg0.getY());
                } else if (RecordsetViewPanel.this.jtblRecords.getSelectedRow() > -1) {
                    RecordsetViewPanel.this.getApplication().postEvent(new Command(this, "msg-selected-record", RecordsetViewPanel.this.getSelectedRecord()));
                }
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }
        });
        this.jPanel1.add((Component)this.uibanner, "Center");
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jLabel1, null);
        this.jPanel2.add((Component)this.jcbViews, null);
        this.add((Component)this.jspRecords, "Center");
        this.jspRecords.getViewport().add((Component)this.jtblRecords, null);
        this.jtblRecords.addMouseListener(this);
        this.jtblRecords.getTableHeader().setReorderingAllowed(false);
        this.add((Component)this.jPanel1, "North");
        this.ftcr2 = new FlatTableCellRenderer();
        this.ftcr2.setBackground(SystemColor.controlLtHighlight);
        this.ftcr2.setForeground(SystemColor.controlText);
        this.ftcr2.setAlternateBackground(SystemColor.control);
        this.ftcr2.setAlternateForeground(SystemColor.controlText);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.jtblRecords.setDefaultRenderer(clazz, this.ftcr2);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.jtblRecords.setDefaultRenderer(clazz2, this.ftcr2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.jtblRecords.setDefaultRenderer(clazz3, this.ftcr2);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.jtblRecords.setDefaultRenderer(clazz4, this.ftcr2);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.jtblRecords.setDefaultRenderer(clazz5, this.ftcr2);
        FlatTableCellRenderer ftcr = new FlatTableCellRenderer();
        ftcr.setBackground(SystemColor.controlDkShadow);
        ftcr.setForeground(SystemColor.controlLtHighlight);
        ftcr.setHorizontalAlignment(2);
        this.jspRecords.addMouseListener(this);
        this.jtblRecords.getTableHeader().setDefaultRenderer(ftcr);
    }

    private void onViewChange(ItemEvent e) {
        Command c;
        if (e.getStateChange() != 1) {
            return;
        }
        if (this.jcbViews.getSelectedIndex() == 0) {
            this.tableModel.setViewName(null);
        } else if (this.jcbViews.getSelectedIndex() == this.jcbViews.getModel().getSize() - 1) {
            c = new Command(this, "cmd-show-view-maker-gui", null);
            this.getApplication().postEvent(c);
        } else {
            String viewName = this.jcbViews.getSelectedItem().toString();
            this.tableModel.setViewName(viewName);
            PilotDBView v = this.tableModel.getDatabase().getView(viewName);
            int i = 0;
            while (i < v.getColumnCount()) {
                this.jtblRecords.getColumnModel().getColumn(i).setPreferredWidth(v.getColumn(i).getFieldWidth());
                ++i;
            }
        }
        c = new Command(this, "msg-windowstate-changed", this);
        this.getApplication().postEvent(c);
    }

    private void onTableDoubleClick() {
        int selectedRow = this.jtblRecords.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        PilotDBRecord record = (PilotDBRecord)this.tableModel.getDatabase().getRecord(selectedRow);
        this.application.postEvent(new Command(this, "cmd-show-record", record));
    }

    void updateColumnWidthPreferences() {
        Runnable r = new Runnable(){

            public void run() {
                String viewName = RecordsetViewPanel.this.tableModel.getViewName();
                if (viewName != null) {
                    PilotDBView view = RecordsetViewPanel.this.tableModel.getDatabase().getView(viewName);
                    int c = 0;
                    while (c < view.getColumnCount()) {
                        view.getColumn(c).setFieldWidth(RecordsetViewPanel.this.jtblRecords.getColumnModel().getColumn(c).getWidth());
                        ++c;
                    }
                    RecordsetViewPanel.this.tableModel.getDatabase().markAsDirty();
                } else {
                    UserPreferences up = RecordsetViewPanel.this.getApplication().getUserPreferences();
                    String[] names = new String[RecordsetViewPanel.this.tableModel.getColumnCount()];
                    int[] widths = new int[names.length];
                    RecordsetViewPanel.this.currentTableSetup(widths, names);
                    UserPreferences.DbPrefs db = new UserPreferences.DbPrefs();
                    db.dbname = RecordsetViewPanel.this.tableModel.getDatabase().getTitle();
                    int i = 0;
                    while (i < names.length) {
                        UserPreferences.Column c = new UserPreferences.Column();
                        c.name = names[i];
                        c.width = widths[i];
                        db.addColumn(c);
                        ++i;
                    }
                    up.setDatabasePrefs(db);
                    try {
                        Application.savePreferences(up);
                    }
                    catch (Exception ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    private void currentTableSetup(int[] widths, String[] names) {
        int i = 0;
        while (i < widths.length) {
            widths[i] = this.jtblRecords.getColumnModel().getColumn(i).getWidth();
            names[i] = this.tableModel.getColumnName(i);
            ++i;
        }
    }

    private void deleteClicked(ActionEvent ae) {
        int[] selected = this.jtblRecords.getSelectedRows();
        PilotDBRecord[] record = new PilotDBRecord[selected.length];
        int i = 0;
        while (i < record.length) {
            record[i] = (PilotDBRecord)this.tableModel.getDatabase().getRecord(selected[i]);
            ++i;
        }
        i = 0;
        while (i < record.length) {
            this.tableModel.getDatabase().deleteRecord(record[i]);
            ++i;
        }
        this.tableModel.fireTableDataChanged();
        Command c = new Command(this, "msg-windowstate-changed", this);
        this.getApplication().postEvent(c);
    }

    private void editClicked(ActionEvent e) {
        int selected = this.jtblRecords.getSelectedRow();
        PilotDBRecord record = (PilotDBRecord)this.tableModel.getDatabase().getRecord(selected);
        this.application.postEvent(new Command(this, "cmd-edit-record", record));
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
        this.enablePopups();
        this.maybeShowPopup(arg0);
    }

    public void mouseReleased(MouseEvent arg0) {
        this.maybeShowPopup(arg0);
    }

    private void maybeShowPopup(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.getPopup().show(this, me.getX(), me.getY());
        }
    }

    private void enablePopups() {
        this.getPopup();
        PilotDBRecord selectedRecord = this.getSelectedRecord();
        this.jmiDeleteRow.setEnabled(selectedRecord != null);
        this.jmiEditRow.setEnabled(selectedRecord != null);
        this.jmiOpen.setEnabled(selectedRecord != null);
    }

    private JPopupMenu getPopup() {
        if (this.jpm == null) {
            this.jpm = new JPopupMenu();
            this.jmiAddRow = new JMenuItem();
            this.jmiDeleteRow = new JMenuItem();
            this.jmiEditRow = new JMenuItem();
            this.jmiOpen = new JMenuItem();
            this.jmiSortAscending = new JMenuItem();
            this.jmiSortDescending = new JMenuItem();
            this.jmiAddRow.setIcon(Images.ADD_RECORD_ICON);
            this.jmiDeleteRow.setIcon(Images.DELETERECORD_ICON);
            this.jmiEditRow.setIcon(Images.EDIT_ICON);
            this.jmiSortAscending.setIcon(Images.ARROW_UP_ICON);
            this.jmiSortDescending.setIcon(Images.ARROW_DOWN_ICON);
            this.jmiAddRow.setText(Messages.getString("RecordsetViewPanel.Add"));
            this.jmiOpen.setText(Messages.getString("RecordsetViewPanel.Open"));
            this.jmiDeleteRow.setText(Messages.getString("RecordsetViewPanel.Delete"));
            this.jmiEditRow.setText(Messages.getString("RecordsetViewPanel.Edit"));
            this.jmiSortAscending.setText(Messages.getString("RecordsetViewPanel.SortOnColumn"));
            this.jmiSortDescending.setText(Messages.getString("RecordsetViewPanel.SortOnColumnDesc"));
            this.jmiOpen.addActionListener(this);
            this.jmiAddRow.addActionListener(this);
            this.jmiEditRow.addActionListener(this);
            this.jmiDeleteRow.addActionListener(this);
            this.jmiSortAscending.addActionListener(this);
            this.jmiSortDescending.addActionListener(this);
            this.jpm.add(this.jmiAddRow);
            this.jpm.addSeparator();
            this.jpm.add(this.jmiOpen);
            this.jpm.add(this.jmiEditRow);
            this.jpm.add(this.jmiDeleteRow);
            this.jpm.addSeparator();
            this.jpm.add(this.jmiSortAscending);
            this.jpm.add(this.jmiSortDescending);
        }
        return this.jpm;
    }

    public void actionPerformed(ActionEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.jmiAddRow) {
            this.addClicked(arg0);
        } else if (source == this.jmiDeleteRow) {
            this.deleteClicked(arg0);
        } else if (source == this.jmiEditRow) {
            this.editClicked(arg0);
        } else if (source == this.jmiOpen) {
            this.onTableDoubleClick();
        } else if (source == this.jmiSortAscending) {
            this.doSort(false);
        } else if (source == this.jmiSortDescending) {
            this.doSort(true);
        }
    }

    private void doSort(boolean desc) {
        int columnSelected = this.jtblRecords.getSelectedColumn();
        if (columnSelected < 0) {
            return;
        }
        this.tableModel.getDatabase().sort(columnSelected, desc);
        this.tableModel.fireTableDataChanged();
        Command c = new Command(this, "msg-windowstate-changed", this);
        this.getApplication().postEvent(c);
    }

    public void itemStateChanged(ItemEvent arg0) {
        this.onViewChange(arg0);
    }

    private void addClicked(ActionEvent e) {
        try {
            PilotDBRecord newRecord = this.tableModel.getDatabase().createRecord();
            this.tableModel.fireTableDataChanged();
            this.application.postEvent(new Command(this, "cmd-edit-record", newRecord));
        }
        catch (Exception ioe) {
            Command c = new Command(this, "cmd-show-error", ioe);
            this.getApplication().postEvent(c);
        }
    }

    public void sizeColumns() {
        int[] columnMaxWidths = this.getColumnWidths();
        TableColumnModel model = this.jtblRecords.getColumnModel();
        int i = 0;
        while (i < columnMaxWidths.length) {
            model.getColumn(i).setPreferredWidth(columnMaxWidths[i] + 20);
            ++i;
        }
    }

    private int[] getColumnWidths() {
        FontMetrics fm = this.getFontMetrics(this.ftcr2.getFont());
        int rows = this.tableModel.getRowCount();
        int cols = this.tableModel.getColumnCount();
        int[] widths = new int[cols];
        int c = 0;
        while (c < cols) {
            widths[c] = fm.stringWidth(this.tableModel.getDatabase().getSchema().getField(c).getName());
            ++c;
        }
        c = 0;
        while (c < cols) {
            int r = 0;
            while (r < rows) {
                widths[c] = Math.max(widths[c], fm.stringWidth(String.valueOf(this.tableModel.getValueAt(r, c))));
                ++r;
            }
            ++c;
        }
        return widths;
    }

    class ViewComboBoxModel
    implements ComboBoxModel {
        PilotDBDatabase db = null;
        String selected = null;
        int viewCount = 0;
        List ldl = new LinkedList();

        ViewComboBoxModel(PilotDBDatabase db) {
            this.db = db;
            this.viewCount = db.getViewCount();
            this.selected = (String)this.getElementAt(0);
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public void setSelectedItem(Object arg0) {
            this.selected = (String)arg0;
        }

        public void addListDataListener(ListDataListener arg0) {
            this.ldl.add(arg0);
        }

        private void fireListDataEvent(ListDataEvent lde) {
            int i = 0;
            while (i < this.ldl.size()) {
                ListDataListener ldls = (ListDataListener)this.ldl.get(i);
                ldls.contentsChanged(lde);
                ++i;
            }
        }

        public Object getElementAt(int arg0) {
            int newViewCount = this.db.getViewCount();
            if (this.viewCount != newViewCount) {
                ListDataEvent lde = new ListDataEvent(this, 0, 0, 0);
                this.fireListDataEvent(lde);
                this.viewCount = newViewCount;
            }
            if (arg0 == 0) {
                return Messages.getString("RecordsetViewPanel.AllFields");
            }
            if (arg0 == this.viewCount + 1) {
                return Messages.getString("RecordsetViewPanel.CreateANewView");
            }
            return this.db.getView(arg0 - 1).getName();
        }

        public int getSize() {
            int newViewCount = this.db.getViewCount();
            if (this.viewCount != newViewCount) {
                ListDataEvent lde = new ListDataEvent(this, 0, 0, 0);
                this.fireListDataEvent(lde);
                this.viewCount = newViewCount;
            }
            return this.viewCount + 2;
        }

        public void removeListDataListener(ListDataListener arg0) {
            this.ldl.remove(arg0);
        }
    }
}

